# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..12\n"; }
END {print "not ok 1\n" unless $loaded;}
use Data::Tuple::Space;
use Data::Dumper;
$Data::Dumper::Indent=1;
$^W=1;

$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

my $space=new Data::Tuple::Space;
my @Ts;
$Ts[0]=$space->add("(Hugh, father, Philip)");
$Ts[1]=$space->add("Hugh, father, Daniel");
$Ts[2]=$space->add(['Hugh', 'father', 'Alice']);
$Ts[3]=$space->add([qw(Hugh client Philip)]);
    
$space->add(q((a, b, c), d));
$space->add(q("a, b, c", d));

my $q=2;

# all of Hugh's children
my @ret=$space->search([qw(Hugh father ?)]);
print ((@ret==3) ? '' : 'not ');
print "ok $q\n";
$q++;

# 3, 4, 5
foreach my $res (@ret) {
    print(($res->as_tuple eq $Ts[2] or $res->as_tuple eq $Ts[1] or
           $res->as_tuple eq $Ts[0]) ? '' : 'not ');
    print "ok $q\n";
    $q++;
}


# 6
my $relationships=Data::Tuple::Space->prepare("(Hugh, ?, Philip)");
@res=$space->search($relationships);
print ((2==scalar @res) ? '' : 'not ');
print "ok $q\n";
$q++;

# 7, 8
foreach my $res (@res) {
    my $n=$res->missing_member;
#    warn "Hugh $n Philip\n";
    print (($n eq 'client' or $n eq 'father') ? '' : 'not ');
    print "ok $q\n";
    $q++;
}


# multi-layer tuples
$space->add("(Service, subscribed, (Kernel, Session, Event))");

# 9
@res=$space->search([qw(Service subscribed ?)]);
print ((@res==1) ? '' : 'not ');
print "ok $q\n";
$q++;

# 10
my $res=$res[0];
$res=$res->missing_member;
print ((ref $res) ? '' : 'not ');
print "ok $q\n";
$q++;

$space->add("(Service, snub, fimple)");

# 11
@res=$space->search([qw(Service ? ?)]);
# warn Dumper \@res;
print ((@res==2) ? '' : 'not ');
print "ok $q\n";
$q++;

# 12
my $ok;
foreach my $res (@res) {
    next unless $res->missing_member(0) eq 'snub';
    $ok++ if $res->missing_member(1) eq 'fimple';
}
print ($ok==1 ? '' : 'not ');
print "ok $q\n";
$q++;

# 13
$space=new Data::Tuple::Space;
my $t=$space->add('a, a, a');
if($space->search('?, a, ?') != 1) {
    print "not ";
}
print "ok $q\n";
$q++;

$space->remove($t);

# warn Dumper $space;
if($space->search('?, a, ?')) {
    print "not ";
}
print "ok $q\n";
$q++;

# warn Dumper $space;