# $Id: 30_save.t,v 1.2 2001/07/27 00:34:42 fil Exp $
use strict;
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..10\n"; }
use JAAS::Config;
use Data::Dumper;

my $loaded = 1;
END {print "not ok 1\n" unless $loaded;}
print "ok 1\n";

#####################################################
my $conf=JAAS::Config->new('t/test1.conf');
print $conf ? '' : 'not ';
print "ok 2\n";
# die Dumper \%INC;
die $@ unless $conf;

my $s='0987654';
                # test hash merge
$conf->set(qw(Object Merchant args), TVP=>$s)
    or die Dumper $conf;
my $tvp=$conf->get(qw(Object Merchant args TVP));
print $tvp ? '' : 'not ';
print "ok 3\n";
print ref($tvp) ? 'not ' : '';
print "ok 4\n";

print $tvp==$s ? '' : 'not ';
print "ok 5\n";

                # test array merge
$conf->set(qw(foo bar biff), [4..8]);
                # test array merge
$conf->set(qw(session IKC), {ctor=>'spawn'});

$conf->save();
undef($conf);



my $conf2=JAAS::Config->new('t/test1.conf');
die $@ unless $conf2;
$tvp=$conf2->get(qw(Object Merchant args TVP));
print $tvp ? '' : 'not ';
print "ok 6\n";
print ref($tvp) ? 'not ' : '';
print "ok 7\n";

print $tvp==$s ? '' : 'not ';
print "ok 8\n";

my $biff=$conf2->get(qw(foo bar biff));
die Dumper $conf2 unless $biff and ref $biff;
print $biff->[7]==8 ? '' : 'not ';
print "ok 9\n";

my $ikc=$conf2->get(qw(session IKC));
die Dumper $conf2 unless $ikc;
print $ikc->{ctor} eq 'spawn' ? '' : 'not ';
print "ok 10\n";

unlink("t/test1.conf.delta") or die $!;
