# $Id: NULL.pm,v 1.1 2001/11/14 05:30:43 fil Exp $
package JAAS::Log::NULL;

use strict;
use vars qw($VERSION);
use POSIX qw(strftime);

$VERSION = '0.01';

BEGIN {
    if($INC{"JAAS/Object/Services.pm"})
    { *DEBUG=sub () {JAAS::Object::Services->debug()}; }
    else { *DEBUG=sub () { 0 }; }
}

##########################################################
sub new
{
    my($package, $args)=@_;

    return bless {}, $package;
}

##########################################################
sub HUP
{
    return;
}

##########################################################
sub message
{
    return;
}

1;

__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

JAAS::Log::NULL - exception media that does DIDLY

=head1 SYNOPSIS

    <media null>
        package=JAAS::Log::NULL
    </media>
    <media stderr>
        package=JAAS::Log::STDERR
    </media>
    # ... other triggers here

    # default media for type=>log is the bit bucket
    <trigger 00>
        type=log
        media=null
    </trigger>

    # default media for all other types is stderr
    <tigger 01>
        monitor_matches=0
        media=stderr
    </trigger>

=head1 DESCRIPTION

This type of exception sink does nothing!  It is provided so that you can
weed out some exceptions and simplify your catch-all triggers.

=head1 METHODS

=head2 new

    my $sink=JAAS::Log::NULL->new($params);

Instantiates an empty object.  

=head2 HUP

Does nothing.

=head2 message

    $sink->message($exception);

Does nothing.

=head1 AUTHOR

Philip Gwyn <jaas at awale.qc.ca>, 
Learry Gagn <mou-jaas at awale.qc.ca>.

=head1 SEE ALSO

perl(1), POE, L<POE::Catcher>

=cut

$Log: NULL.pm,v $
Revision 1.1  2001/11/14 05:30:43  fil
Added support for all the funky, junky, monkey logging.  Hope I docoed it too.

