# $Id: STDERR.pm,v 1.1 2001/11/14 05:30:43 fil Exp $
package JAAS::Log::STDERR;

use strict;
use vars qw($VERSION @ISA);
use JAAS::Log::Sink;
use POSIX qw(SEEK_END);

$VERSION = '0.01';
@ISA=qw(JAAS::Log::Sink);

BEGIN {
    if($INC{"JAAS/Object/Services.pm"})
    { *DEBUG=sub () {JAAS::Object::Services->debug()}; }
    else { *DEBUG=sub () { 0 }; }
}

##########################################################
sub output
{
    my($self, $msg)=@_;
    print STDERR $msg;
    print STDERR "\n" unless "\n" eq substr($msg, -length("\n"));;
}

1;

__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

JAAS::Log::STDERR - Log a message to STDERR

=head1 SYNOPSIS

    <media file1>
        class=JAAS::Log::STDERR
        syntax=[time] [pid] [package]([line]) [text]
    </media>
   

=head1 DESCRIPTION

Routes an exception to STDERR (which you've probably redirected).  This is a 
trivial subclass of L<JAAS::Log::Sink>.

=head1 METHODS

=head2 output

    $sink->output($msg);

Writes C<$msg> to STDERR, appending a newline if one is needed.

=head1 AUTHOR

Philip Gwyn <jaas at awale.qc.ca>, 
Learry Gagn <mou-jaas at awale.qc.ca>.

=head1 SEE ALSO

perl(1), POE, L<JAAS::Log::Sink>

=cut

$Log: STDERR.pm,v $
Revision 1.1  2001/11/14 05:30:43  fil
Added support for all the funky, junky, monkey logging.  Hope I docoed it too.

