use strict;

# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

my $loaded;

BEGIN { $| = 1; print "1..7\n"; }
END {print "not ok 1\n" unless $loaded;}
use JAAS::Catcher qw(around EXEC_CTX);
use Carp;
use Data::Dumper;

$loaded = 1;
print "ok 1\n";

######################### End of black magic.
sub should_be ($);

my $q=2;


wrap JAAS::Catcher around { warn "test1" };
should_be {
        line=>__LINE__-2, src_file=>__FILE__, package=>__PACKAGE__,
        text=>'test1',
};

wrap JAAS::Catcher around { die "test2" };
should_be {
        line=>__LINE__-2, src_file=>__FILE__, package=>__PACKAGE__,
        text=>'test2',
};

wrap JAAS::Catcher with MyError 
    around {warn "this is the message that you are looking for" };
should_be { yibble=>"yes", line=>-42 };

sub do_carp { carp 'test3' }
JAAS::Catcher->monitor(sub { do_carp; });
should_be { line=>__LINE__-1, text=>'test3'};

sub do_croak { croak 'test4' }
JAAS::Catcher->monitor(sub { do_croak; warn "Don't show me"});
should_be { line=>__LINE__-1, text=>'test4'};

#################################################
my $perl5_004= $] <5.005;

sub something {
    EXEC_CTX(my $f, {one=>'two'});
    die {hello=>'world'} unless $perl5_004;
    die "HELLO WORLD";
}
JAAS::Catcher->monitor(\&something);
should_be { hello=>'world', one=>'two'} unless $perl5_004;
should_be { text=>'HELLO WORLD', one=>'two'} if $perl5_004;




###########################################################################
sub should_be ($)
{
    my($against)=@_;
    my $stack=JAAS::Catcher->get_stack;
    JAAS::Catcher->clear_stack;
    if(@$stack != 1) {
        warn Dumper $stack;
        print 'not ';
    } else {
        my $msg=$stack->[0];
        foreach my $k (keys %$against) {
            next if defined ($msg->{$k}) and $msg->{$k} eq $against->{$k};
            my $q=defined $msg->{$k} ? "'$msg->{$k}'" : 'undef()';
            warn "$k: $q should be '$against->{$k}'\n";
            print 'not ';
            last;
        }
    }
    print "ok $q\n";
    $q++;
}





###########################################################################
package MyError;
use strict;

BEGIN {
@MyError::ISA=qw(JAAS::Error);
}
sub new
{
    return {yibble=>"yes", line=>-42};
}

