use strict;

# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

my $loaded;

BEGIN { $| = 1; print "1..6\n"; }
END {print "not ok 1\n" unless $loaded;}
use JAAS::Monitor;
use Carp;
use Data::Dumper;

$loaded = 1;
print "ok 1\n";

######################### End of black magic.
my $watch=JAAS::Monitor->new();

my @ids;
my $Q=2;

push @ids, $watch->add({fibble=>"flip", ingy=>1}, sub {
                print 'not ' unless $Q==3;
                print "ok ", $Q++, "\n";
            });
push @ids, $watch->add({fibble=>'flip'}, sub {
                print 'not ' unless $Q==2 or $Q==4;
                print "ok ", $Q++, "\n";
            });

push @ids, $watch->add({something=>0}, sub {
                print 'not ' unless $Q==6;
                print "ok ", $Q++, "\n";
            });

push @ids, $watch->add({something=>''}, sub {
                print 'not ' unless $Q==5;
                print "ok ", $Q++, "\n";
            });

$watch->checks([{fibble=>'flip', biff=>'boff'}, 
                {fibble=>'flip', ingy=>1},
                {nibble=>'foo'},                # should do NOTHING
                {something=>''}, 
                {something=>0}]);

$watch->remove($ids[2]);
$watch->checks([{something=>0}]);

foreach ($Q..6) {
    print "not ok $_\n";
}
