use strict;

# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

my $loaded;
my $no_poe;
BEGIN { $| = 1; print "1..3\n"; }
END {print "not ok 1\n" unless $loaded;}
BEGIN {
    $no_poe=1;
    eval {
        use POE::Kernel;
        use POE::Session;
        $no_poe=0;
    };
}
use JAAS::Monitor;
use Carp;
use Data::Dumper;

$loaded = 1;
print "ok 1\n";

######################### End of black magic.
if($no_poe) {
    foreach my $q (2..4) {
        print "skip $q\n";
    }
    exit 0;
}

my $MON=JAAS::Monitor->new();
$MON->add({something=>1}, ['hey!'=>'one']);
$MON->add({something=>2}, ['hey!'=>'two']);

my $Q=2;

POE::Session->create(
    inline_states=>{
        _start=>sub {
            $_[KERNEL]->alias_set('hey!');
            $MON->checks([{something=>1}]);
        },
        one=>sub {
            print 'not ' unless $Q==2;
            print "ok $Q\n";
            $Q++;
            $MON->checks([{something=>2}]);
        },
        two=>sub {
            print 'not ' unless $Q==3;
            print "ok $Q\n";
            $Q++;
            $MON->checks([{something=>4}]);
        },
    }
);

$poe_kernel->run();

foreach ($Q..3) {
    print "not ok $_\n";
}
