use strict;

# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)
use lib qw(/home/fil/prive/lib blib/lib
        /home/fil/work/JAECA/JAAS/perl5lib/lib/site_perl
        /home/jaeca/perl5lib/lib/site_perl);

my $loaded;
my $no_services;
BEGIN { $| = 1; print "1..6\n"; }
END {print "not ok 1\n" unless $loaded;}
BEGIN {
    $no_services=1;
    eval {
        use POE::Kernel;
        use JAAS::Object::Services;
        use JAAS::Object;
        use JAAS::Config;
        use JAAS::Factory;
        $no_services=0;
    };
    warn $@ if $@;
    if($no_services) {
        foreach my $q (2..5) {
            print "skip $q\n";
        }
        exit 0;
    }
}

use JAAS::Log;
use JAAS::Log::File;
use JAAS::Log::STDERR;
use Carp;
use Data::Dumper;

$loaded = 1;
print "ok 1\n";
my $Q=2;

my $config=JAAS::Config->new();
$config->add(<<CONFIG);
    <Session monitor>
        class=JAAS::Log
        <args>
            <media file1>
                class=JAAS::Log::File
                file=./temp.1
                syntax=[time] 1- "[text]" [array.1]
            </media>
            <media file2>
                class=JAAS::Log::File
                dest=./temp.2
                syntax=2- "[text]" [array.1]
            </media>
            <media file3>
                class=JAAS::Log::File
                dest=./temp.2
                syntax=Never! [text]
            </media>
            <trigger file1>
                type=1
            </trigger>
            <trigger file2>
                type=2
                media=file2
            </trigger>
            <trigger file1>
                type=3
                media=file2
                media=file1
                media=file2
            </trigger>
            <trigger ~~>
                type=1
                monitor_matches=0
                media=file3
            </trigger>
        </args>    
    </Session>

CONFIG

# use Data::Denter;
# warn Denter $config;

my $factory=JAAS::Factory->new($config);

my $monitor=$factory->make('monitor', $factory) or die $@;

print "ok ", $Q++, "\n";        # 2

$monitor->checks({type=>1, text=>"Hello world", array=>[qw(fee fie foo)]});
$monitor->checks({type=>2, text=>"Hello world", array=>[qw(fee fie foo)]});
$monitor->checks({         text=>"Never"});
$monitor->HUP();
print "ok ", $Q++, "\n";        # 3

foreach my $q (1, 2) {
    open FILE, "./temp.$q" or die "Opening ./temp.$q: $!";
    while(<FILE>) {
        print "not " if !/$q-/ or /Never/ or !/"Hello world"/  or
                        !/fie/;
        print "ok ", $Q++, "\n";  # 4, 5, 6
    }
    close FILE;
}

END { 
    unlink "./temp.1" if -e './temp.1'; 
    unlink "./temp.2" if -e './temp.2';
}










1;