use strict;

# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)
use lib qw(/home/fil/prive/lib blib/lib
        /home/fil/work/JAECA/JAAS/perl5lib/lib/site_perl
        /home/jaeca/perl5lib/lib/site_perl);

my $loaded;
my $no_services;
BEGIN { $| = 1; print "1..7\n"; }
END {print "not ok 1\n" unless $loaded;}
BEGIN {
    $no_services=1;
    eval {
        use POE::Kernel;
        use JAAS::Object::Services;
        use JAAS::Object;
        use JAAS::Config;
        use JAAS::Factory;
        $no_services=0;
    };
    warn $@ if $@;
    if($no_services) {
        foreach my $q (2..5) {
            print "skip $q\n";
        }
        exit 0;
    }
}

use JAAS::Log;
use JAAS::Log::Mail;
use Carp;
use Data::Dumper;
use vars qw($Q);

$loaded = 1;
print "ok 1\n";
$Q=2;

sub DEBUG () { 0 }

my $config=JAAS::Config->new();
$config->add(<<CONFIG);
    <Session monitor>
        class=JAAS::Log
        <args>
            <media STDERR>
                class=JAAS::Log::STDERR
                syntax=[dump]
            </media>
            <media mailbatch>
                mailer=mailer1
                class=JAAS::Log::Mail
                to=ignored
                syntax=[time] [to]:\\n[text]
                max-time=5
                min-time=1
            </media>
            <media rightnow>
                mailer=mailer2
                class=JAAS::Log::Mail
                to=ignored;also
                syntax=this is the syntax with a \t in it
            </media>
            <trigger mailbatch>
                to=mailbatch
            </trigger>
            <trigger rightnow>
                to=rightnow
            </trigger>
            <trigger ~~>
                monitor_matches=0
                media=STDERR
            </trigger>
        </args>    
    </Session>
    <Session mailer1>
        class=MyMailer
        <args>
            match mailbatch
            match \\n
        </args>
    </Session>
    <Session mailer2>
        class=MyMailer
        <args>
            match this is the syntax with a \t in it
        </args>
    </Session>
    <Session feeder>
        class=Feeder
        <args>
            <feed>
                to=mailbatch
                text=hello
            </feed>
            <feed>
                to=mailbatch
                text=world
            </feed>
            <feed>
                to=rightnow
                text=world
            </feed>
            <feed>
                to=mailbatch
                text=RIBIDLE SWITCH
            </feed>
        </args>
    </Session>
    <debug>
        JAAS::Log::Mail=0
        JAAS::Log::Sink=0
        JAAS::Log=0
        JAAS::Monitor=0
    </debug>
CONFIG

# use Data::Denter;
# warn Denter $config;

JAAS::Object::Services->spawn($config);
my $factory=JAAS::Factory->new($config);

$factory->make('mailer1') or die $@;
$factory->make('mailer2') or die $@;
$factory->make('monitor', $factory) or die $@;
$factory->make('feeder')    or die $@;
print "ok ", $Q++, "\n";        # 2



$poe_kernel->run();

print "ok 7\n";







###################################################################
package Feeder;
use strict;
use POE::Session;

sub spawn
{
    my($package, $args)=@_;
    $args->{feed}=[$args->{feed}] unless ref $args->{feed};

    POE::Session->create(
        package_states=>[
            $package=>[qw(_start feed)],
        ],
        heap=>$args,
    );
}

sub _start
{
    my($kernel, $heap)=@_[KERNEL, HEAP];
    $kernel->yield('feed');
}

sub feed
{
    my($kernel, $heap)=@_[KERNEL, HEAP];
    my $n=shift @{$heap->{feed}};
    return unless $n;

    $kernel->post(monitor=>'checks', [$n]);

    $kernel->delay(feed=>1);
    return;
}

###################################################################
package MyMailer;
use strict;
use POE::Session;

BEGIN { *DEBUG=\&::DEBUG; }

sub spawn
{
    my($package, $args)=@_;
    $args->{match}=[$args->{match}] unless ref $args->{match};

    POE::Session->create(
        package_states=>[
            $package=>[qw(_start mail pgp5mail)],
        ],
        heap=>$args
    );
}

sub _start
{
    my($kernel, $heap)=@_[KERNEL, HEAP];
    $kernel->alias_set($heap->{name});
}

sub mail
{
    my($kernel, $heap, $args)=@_[KERNEL, HEAP, ARG0];
    {
        local $"=", ";
        DEBUG and print STDERR "Matching '$args->{text}' to '@{$heap->{match}}'\n";
    }
    foreach my $n (@{$heap->{match}}) {
        next if ($args->{text}||'') =~ /$n/;
        DEBUG and print STDERR "Don't have $n\n";
        print "not ";
        last;
    }
    print "ok ", $::Q++, "\n";      # 3, 4, 5, 6
}

BEGIN { *pgp5mail=\&mail;}

