# $Id: 40_continuation.t,v 1.1 2001/09/19 07:57:40 fil Exp $
use strict;
BEGIN { $Data::Dumper::Indent=1;}
use Data::Dumper;

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..11\n"; }

sub POE::Kernel::TRACE_REFCOUNT {0}
sub POE::Kernel::TRACE_EVENTS{0}

sub POE::Kernel::ASSERT_DEFAULT {1}

use JAAS::Object;
use JAAS::Object::Services;
use POE::Kernel;
use Carp;
JAAS::Object::Services->spawn();

my $loaded = 1;
END {print "not ok 1\n" unless $loaded;}
print "ok 1\n";

my $Q=2;

###################################################################
# Create objects and define their public methods

JAAS::Object->spawn(object=>
        Over->new({
            name=>'Over', 
            methods=>{
                one=>{},
                two=>{},
                three=>{args_n=>1},
            }
        }));

JAAS::Object->spawn(object=>
        Under->new({
            name=>'Under', 
            methods=>{
                one=>{args_n=>1, respond=>1},
                two=>{args_n=>1},
                three=>{args_n=>1},
            }
        }));

JAAS::Object->spawn(object=>
        Friend->new({
            name=>'Friend', 
            methods=>{
                one=>{args_n=>1},
                two=>{args_n=>1},
            }
        }));

JAAS::Object->spawn(object=>
        Runner->new({
            name=>'Runner', 
            methods=>{
                one=>{},
                two=>{},
            }
        }));


################################################################
# start the ball rolling
# warn "***********************\n";

ok(2);
$poe_kernel->post(Runner=>'one');
# warn "Running...";
$poe_kernel->run();

ok(11);

################################################################
sub ok
{
    my($n, $ok)=@_;
    croak "$n is a reference" if ref $n;
    croak "$n is a bit excessive" if $n > 1000;

    print "# line ", (caller())[2], "\n";

    my $not=(@_==1 or $ok) ? '' : "not ";
    my $msg='';
    if(defined $n) {
        if($n < $Q) {
            $not="not ";
            $msg=" # should be $n!";
        } elsif($n > $Q) {
            foreach my $i ($Q .. ($n-1)) {
                print "not ok $i\n";
            }
            $Q=$n;
        }
    }
    print "${not}ok $Q$msg\n";
    $Q++;
    die "$Q is too big" if $Q > 12;
}


################################################################
package Base;
use strict;
use JAAS::Object::Services;
use Data::Dumper;

use JAAS::Object::Delegate;
use vars qw(@ISA);
BEGIN { @ISA=qw(JAAS::Object::Delegate);}

sub new
{
    my($package, $args)=@_;
    die "no methods" unless $args->{methods};
    die "no name" unless $args->{name};
    my $self=$package->SUPER::new($args);
    return $self;
}

sub methods { return %{$_[0]->{methods}}}


################################################################
package Under;
use strict;
use JAAS::Object::Services;
use Data::Dumper;

use JAAS::Object::Delegate;
use vars qw(@ISA);
BEGIN { @ISA=qw(Base);}

sub one
{
    my($self, $q)=@_;
    ::ok(4);
    $self->continuation('two', ++$q);
}

sub two
{
    my($self, $q)=@_;
    ::ok(5);
    $self->continuation({to=>'one@Friend', 'reply-to'=>'three'}, ++$q);
}

sub three
{
    my($self, $q)=@_;
    ::ok(8);
    return $q;
}

################################################################
package Friend;
use strict;
use JAAS::Object::Services;
use Data::Dumper;

use JAAS::Object::Delegate;
use vars qw(@ISA);
BEGIN { @ISA=qw(Base);}

sub one
{
    my($self, $q)=@_;
    ::ok(6);
    $self->continuation('two', --$q);
}

sub two
{
    my($self, $q)=@_;
    ::ok(7);
    return --$q;
}

################################################################
package Over;
use strict;
use JAAS::Object::Services;
use Data::Dumper;

use JAAS::Object::Delegate;
use vars qw(@ISA);
BEGIN { @ISA=qw(Base);}

sub one
{
    my($self)=@_;
    ::ok(3);
    $self->continuation('two');
}

sub two
{
    my($self)=@_;
    $self->continuation({to=>'one@Under', 'reply-to'=>'three'}, 42);
}

sub three
{
    my($self, $q)=@_;
    ::ok(9, ($q==42));
}

################################################################
package Runner;
use strict;
use JAAS::Object::Services;
use Data::Dumper;

use JAAS::Object::Delegate;
use vars qw(@ISA);
BEGIN { @ISA=qw(Base);}

sub one
{
    my($self)=@_;
    $jaas_services->post({to=>'one@Over', 'reply-to'=>'two'});
}

sub two
{
    my($self)=@_;
    ::ok(10);
}

