# $Id: 20_cache.t,v 1.5 2002/04/17 19:24:51 fil Exp $
use strict;
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..14\n"; }
use JAAS::Object::Cache::Persistant;
use JAAS::Object::Cache::Simple;
use Data::Dumper;

$Data::Dumper::Indent=3;
my $loaded = 1;
END {print "not ok 1\n" unless $loaded;}
print "ok 1\n";

my $ok=2;

foreach my $package (qw(JAAS::Object::Cache::Simple
                        JAAS::Object::Cache::Persistant)) {

    my $lifer=new Test::Lifer;
    my $cache=$package->new($lifer);

    foreach my $id (1..2) {
        $cache->setup($id, 'me');
        foreach my $n (0..1) {
            $cache->store($id, $n, Test::N->new($id*2+$n));
        }
    }

    # 2..5, 7..10
    foreach my $id (1..2) {
        foreach my $n (0..1) {
            my $q=$cache->fetch($id, $n);
            print $$q == $id*2+$n ? '' : 'not ';
            print "ok ", $ok++, "\n";
        }
    }

    foreach my $id (1..2) {
        $cache->clear($id, 'me');
    }

    # 6, 11
    my $q=$cache->fetch(1, 1);
    print $q ? 'not ' : '';
    print "ok ", $ok++, "\n";

    next if $package =~ /Simple$/;

    my $id='context';
    my $obj='object';

    $cache->setup($id, 'me');
    $cache->store($id, $obj, Test::N->new(42));     

    $cache->setup($id, 'myself');                   # 2 folks interested
    $cache->clear($id, 'me');                       # now only myself

    # 12
    $q=$cache->fetch($id, $obj);
    die "Where did it go???\n", Dumper $cache unless $q;
    print $$q == 42 ? '' : 'not ';
    print "ok ", $ok++, "\n";

    # 13
    $cache->clear($id, 'myself');                   # nobody!
    $q=$cache->fetch($id, $obj);
    print $q ? 'not ' : '';
    print "ok ", $ok++, "\n";

    # 14
    $cache->setup($id, 'me');                       # should cause restore
    $q=$cache->fetch($id, $obj);
    die "\nShould have been restored $id $obj 'me'\n", Dumper $cache 
                            unless $q;
    print $$q == 42 ? '' : 'not ';
    print "ok ", $ok++, "\n";
    $cache->clear($id, 'me');
}


##################################################################
package Test::N;
sub new { my $n=$_[1]; bless \$n, $_[0]}

##################################################################
package Test::Lifer;
use strict;
use Data::Dumper;
sub new { bless {}, $_[0]}
use vars qw($VAR1);
sub save
{
    my($self, $objects, $when, $id)=@_;
    local $Data::Dumper::Indent=0;
    $self->{$id}{$when}=Dumper $objects;
    # warn "SAVE $id $when=", $self->{$id}{$when};
}

sub restore
{
    my($self, $objects, $when, $id)=@_;
    # warn "RESTORE $id $when =", $self->{$id};
    return unless $self->{$id}{$when};
    local $VAR1;
    
    # warn "RESTORE $id $when =", $self->{$id}{$when};
    $_[1]=eval $self->{$id}{$when};
}

sub lock
{
    return sub {};
}