BEGIN {$^W=1}
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

use lib qw(/home/fil/prive/lib ../lib);

BEGIN {
    sub POE::Kernel::ASSERT_REFCOUNT () {1}
    sub POE::Kernel::ASSERT_USAGE () {1}
#    sub POE::Session::ASSERT_WARN () {1}
#    sub POE::Kernel::TRACE_GARBAGE () {1}
#    sub POE::Kernel::TRACE_REFCOUNT () {1}
#    sub POE::Kernel::TRACE_QUEUE () {1}
#    sub POE::Kernel::TRACE_EVENTS () {1}
    $Data::Dumper::Indent=1;
}

BEGIN { $| = 1; print "1..15\n"; }
END {print "not ok 1\n" unless $loaded;}
use JAAS::Config;
use JAAS::Object::Services;
use JAAS::Object::Delegate;
use JAAS::Server;
use JAAS::Application;
use JAAS::Entrypoint;

$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

my $Q=2;

sub DEBUG () { 0 }

################################################################
sub ok
{
    my($n, $ok)=@_;
#    CORE::print join(' at line ', (caller)[1,2]), "\n";
    my $not=(@_==1 or $ok) ? '' : "not ";
    if(defined $n) {
#        CORE::print $n;
        if($n < $Q) {
            $not="not ";
        } elsif($n > $Q) {
            foreach my $i ($Q .. ($n-1)) {
                print "not ok $i\n";
            }
            $Q=$n;
        }
    }
    print "${not}ok $Q\n";
    $Q++;
}


############################################################################
package TA::Catalog;
use strict;
BEGIN {
    *ok=\&main::ok;
    *DEBUG=\&main::DEBUG;
}

use vars qw(@ISA);
BEGIN { @ISA=qw(JAAS::Object::Delegate)}


#########################################################
sub new
{
    my($package, $args)=@_;
    die "Need data source" unless $args->{data};
    die "Only data source 'file' is implemented" unless $args->{data} eq 'file';
    die "Need $args->{data} source" unless $args->{$args->{data}};
    return $package->SUPER::new($args);
}

#########################################################
sub methods
{
    return (
        search=>{respond=>1},
        items=>{respond=>1},
    );
}

#########################################################
sub open
{
    my($self)=@_;
    if($self->{data} eq 'file') {
        return 1 if $self->{fh} and $self->{fh}->opened;

        $self->{fh}=IO::File->new($self->{file});
        die "Unable to open $self->{file}: $!" unless $self->{fh};
        return 1;
    }
    delete $self->{fh};
    return 0;
}

#########################################################
sub close
{
    my($self)=@_;
    return 1 unless $self->{fh} and $self->{fh}->opened;
    delete $self->{fh};
}

#########################################################
sub search
{
    my($self, $args)=@_;
    ok(2, 'HASH' eq ref $args);

    ok(3, exists $args->{keyword});
    return {SKU=>[10,100,1000], n=>3};
}

#########################################################
sub items
{
    my($self, $args)=@_;
    DEBUG and print STDERR __PACKAGE__, "::items\n";
    ok(5, 'HASH' eq ref $args);
    ok(6, (exists $args->{n} and exists $args->{SKU}));
    use Data::Dumper;
    DEBUG and print STDERR "Look what I got: ", Dumper $args;
    ok(7, ($args->{n} == @{$args->{SKU}}));
    return { 10=>{desc=>"Article 10"}, 
             100=>{desc=>"Article 100"},
            1000=>{desc=>"Article 1000"}};
}










##############################################################################

############################################################################
package TB::Catalog;
use strict;
use Data::Dumper;
use JAAS::Object::Services;

use JAAS::Widget::Text;
use JAAS::Widget::Label;
use JAAS::Widget::List;
use JAAS::Widget::Group::Address;
use JAAS::Widget::Group::CartItem;

BEGIN {
    *ok=\&main::ok;
    *DEBUG=\&main::DEBUG;
}

use vars qw(@ISA);
BEGIN { @ISA=qw(JAAS::Object::Delegate);}


#########################################################
sub new
{
    my($package, $args)=@_;
#    die "Need DBI source" unless $args->{DBI};
    die "no catalog" unless $args->{catalog};
    my $self=$package->SUPER::new($args);
    $self->{1234}=1;
    return $self;
}

#########################################################
sub methods
{
    return (
        search=>{},
        search_res=>{},
        results=>{},
        items=>{}, 
        one=>{}, two=>{}, three=>{},  
        widgets=>{respond=>1},
        display=>{}, update=>{},
    );
}

#########################################################
sub search
{
    my($self, $args)=@_;
    DEBUG and CORE::print "search for ", Dumper $args;
    $self->{as_html}=$args->{format} eq 'html';

    my $cont=$jaas_services->build_continuation("search_res");
    $jaas_services->post("search\@$self->{catalog}", $args, $cont);
    $self->{respond_to}=$jaas_services->sender;
    return;
}


#########################################################
sub search_res
{
    my($self, $items)=@_;
    DEBUG and CORE::print "search_res: ", Dumper $items;
    ok(4, (exists $items->{n} and exists $items->{SKU}));

    my $cont=$jaas_services->build_continuation("results");
    $jaas_services->post("items\@$self->{catalog}", $items, $cont);
}

#########################################################
sub results
{
    my($self, $items)=@_;
    DEBUG and CORE::print "results: ", Dumper $items;
    my $res;
    if($self->{as_html}) {
        
    } else {
        $res=$items;
    }
    delete $self->{respond_to};
    return $res;

    # $jaas_services->post('respond@'.delete($self->{respond_to}), $res);
}


#########################################################
sub one
{
    my($self)=@_;
    ok(9, not exists $self->{q});
    $self->{q}=1;
    return 'two';
}
sub two
{
    my($self)=@_;
    ok(10, ($self->{q}==1));
    $self->{q}++;
    return 'three';
}
sub three
{
    my($self)=@_;
    ok(11, $self->{q}==2);
    $self->{q}++;
    return [$self->{q}, qw(nothing's for free)];
}


#########################################################
sub widgets
{
    my($self, $items)=@_;
    DEBUG and CORE::print __PACKAGE__, "::widgets\n";

    return [
        JAAS::Widget::Text->new(name=>'text', source=>"$self->{name}/text"),
        JAAS::Widget::Label->new(name=>'label'),
        JAAS::Widget::List->new(name=>'list', source=>"$self->{name}/list", 
                                type=>'multi',
                                items=>['1:Francais', '2:English', '3:Russki']
                                ),

        JAAS::Widget::Group::CartItem->new(
                                    name=>'1234', source=>"$self->{name}/1234", 
                                    sku=>1234, title=>"Item 1234",
                                    total_source=>"$self->{name}/total=1234",
                                    price_source=>"$self->{name}/price=1234",
                                ),
    ];

}
#########################################################
sub display
{
    DEBUG and CORE::print __PACKAGE__, "::display\n";
    return '';      # don't really do anything, get_widgets does it all
}

#########################################################
sub update
{
    my($self, $items)=@_;
    # no work to do :)
    DEBUG and CORE::print "update";
    return $self->update();
}

#########################################################
sub get_field
{
    my($self, $field)=@_;
    if($field =~ /=\d+/) {
        return 500;         # everything costs 5 dollars
    }

    return $self->SUPER::get_field($field);
}

sub set_field
{
    my($self, $field, $value)=@_;
    return if $field =~ /=\d+/;        # shouldn't happen!
#    CORE::print "$self $field >> ", (defined($value) ? $value : "undef()");
    return $self->SUPER::set_field($field, $value);
}

##############################################################################

##############################################################################
package TClient;
use strict;
use POE::Session;
use Data::Dumper;

BEGIN {
    *ok=\&main::ok;
    *DEBUG=\&main::DEBUG;
}
my $HERE="poe://YeTeste/TClient";

#########################################################
sub spawn
{
    my($package)=@_;
    POE::Session->create(
        package_states=>[
            $package, [qw(_start _stop resp1 resp2 resp3 resp4 done)],
        ],
    );
}

#########################################################
sub _start
{
    my($kernel, $heap)=@_[KERNEL, HEAP];
    $kernel->alias_set('TClient');
    
    $kernel->call(IKC=>'publish', 0=>[qw(resp1 resp2 resp3 resp4)]);

    $kernel->post(IKC=>'post', 'poe://YeTeste/Catalog/search', 
                    [{format=>'data', keyword=>'hello'}, $HERE.'/resp1']);
}

#########################################################
sub _stop
{
}

#########################################################
sub resp1
{
    my($kernel, $items)=@_[KERNEL, ARG0];
    die "resp1: ", Dumper $items->{error} if $items->{error};
    die "resp1: ", Dumper $items unless 'HASH' eq ref $items;
    # 3 items + PID
    ok(8, 4==keys %$items);

#    $kernel->yield('done');
    $kernel->post(IKC=>'post', 'poe://YeTeste/catalog/search',
                    [{SUBMIT_one=>"something"}, $HERE.'/resp2']);
}

#########################################################
sub resp2
{
    my($kernel, $resp)=@_[KERNEL, ARG0];
    die "resp2: ", Dumper $resp->{error} if $resp->{error};
    DEBUG and CORE::print "resp2 ", Dumper $resp;
    die "resp2: ", Dumper $resp unless $resp->{response};
    my $pid=$resp->{PID};
    $resp=$resp->{response};
    ok(12, 3==$resp->[0]);


    $kernel->post(IKC=>'post', 'poe://YeTeste/catalog/display',
                            [{PID=>$pid}, $HERE.'/resp3']);
}


#########################################################
sub resp3
{
    my($kernel, $resp)=@_[KERNEL, ARG0];
    unless($resp) {
        CORE::print "No response!";
        $kernel->yield('done');
        return;
    }
    my $widgets=$resp->{widgets};

    unless(ref $widgets and 'ARRAY' eq ref $widgets) {
        DEBUG and CORE::print "resp3 didn't get an array: ", Dumper $widgets;
        $kernel->yield('done');
        return;
    }

    # DEBUG and 
        CORE::print "We got: ", Dumper $widgets;
    my $label=0;
    my $p={};                                           # CGI-like params
    my @todo=@$widgets;
    while (@todo) {
        my $w=shift @todo;
        $label=1 if UNIVERSAL::isa($w, 'JAAS::Widget::Label');  # and check :)
        if(UNIVERSAL::isa($w, 'JAAS::Widget::Group')) {  
            push @todo, map {$w->{$_}} @{$w->{_order}};
            next;
        }

        $p->{$w->{name}}=$w->{content} if $w->{name} and exists $w->{content};
    }

    ok(13, (
#            exists $p->{username}   and                 # from Group::Address
            exists $p->{"1234"} and                     # from Group::CartItem
            exists $p->{text} and                       # Widget::Text
            $label and                                  # Widget::Label
            exists $p->{list}                           # Widget::List
           ));

    $p->{list}=[1, 2];
    $p->{text}="HELLO WORLD";
#    $p->{username}="George";
    $p->{"1234"}=10;
    $p->{PID}=$resp->{PID};
    $p->{__widgets__}=$p->{__widgets__};

    DEBUG and 
        CORE::print "We send: ", Dumper $p;
    $kernel->post(IKC=>'post', 'poe://YeTeste/catalog/display',
                            [$p, $HERE.'/resp4']);
    

}

#########################################################
sub resp4
{
    my($kernel, $resp)=@_[KERNEL, ARG0];
    my $p={};                                           # CGI-like params
    my $widgets=$resp->{widgets};
    die "resp4: ", Dumper $resp unless $widgets;
    my @todo=@$widgets;
    while (@todo) {
        my $w=shift @todo;
        if(UNIVERSAL::isa($w, 'JAAS::Widget::Group')) {  
            push @todo, map {$w->{$_}} @{$w->{_order}};
            next;
        }

        $p->{$w->{name}}=$w->{content} if $w->{name} and exists $w->{content};
    }
    DEBUG and 
        CORE::print "We got: ", Dumper $p;
    ok(14, ($p->{text} eq 'HELLO WORLD' and 
            $p->{list}[0] and $p->{list}[1] and not $p->{list}[2] and
#            $p->{username} eq 'George'  and
            $p->{1234} == 10));

    $kernel->yield('done');
}


#########################################################
sub done
{
    my($kernel, $package)=@_[KERNEL, OBJECT];
    $kernel->alias_remove('TClient');
    $kernel->post(IKC=>'shutdown');
}










##############################################################################


##############################################################################
package My::Own::Cache;
use strict;
use JAAS::Object::Cache::Simple;
use vars qw(@ISA);
BEGIN {
    @ISA=qw(JAAS::Object::Cache::Simple);
    *DEBUG=\&main::DEBUG;
}

sub clear
{
    my($self, $id, $who)=@_;
    return unless exists $self->{$id}{_interested}{$who};
    delete $self->{$id}{_interested}{$who};
    # DEBUG and CORE::print "$who isn't interested in $id";

    return if keys %{$self->{$id}{_interested}};    

    # DEBUG and CORE::print "$id is FREE\n";
    return;
}










##############################################################################


##############################################################################
package main;
use strict;
use POE::Kernel;
use JAAS::Object::Services;

JAAS::Server->spawn('entrypoints.conf');

TClient->spawn();

$poe_kernel->run();


ok(15);
