BEGIN {$^W=1}
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

use lib qw(/home/fil/prive/lib ../lib);

BEGIN {
    sub POE::Kernel::ASSERT_REFCOUNT () {1}
    sub POE::Kernel::ASSERT_USAGE () {1}
    sub POE::Kernel::ASSERT_SESSIONS () {0}

    sub POE::Session::ASSERT_WARN () {0}

    sub POE::Kernel::TRACE_REFCOUNT () {0}
    sub POE::Kernel::TRACE_QUEUE () {0}
    sub POE::Kernel::TRACE_EVENTS () {0}
    $Data::Dumper::Indent=1;
}

BEGIN { $| = 1; print "1..26\n"; }
END {print "not ok 1\n" unless $loaded;}
use JAAS::Config;
use JAAS::Object::Services;
use JAAS::Object::Delegate;
use JAAS::Server;
use JAAS::Application;
use JAAS::Entrypoint;
use JAAS::Multipart;

use JAAS::Widget::Label;
use JAAS::Widget::Text;

$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

my $Q=2;

sub DEBUG () { 0 }

################################################################
sub ok
{
    my($n, $ok)=@_;
#    CORE::print join(' at line ', (caller)[1,2]), "\n";
    my $not=(@_==1 or $ok) ? '' : "not ";
    if(defined $n) {
#        CORE::print $n;
        if($n < $Q) {
            $not="not ";
        } elsif($n > $Q) {
            foreach my $i ($Q .. ($n-1)) {
                print "not ok $i\n";
            }
            $Q=$n;
        }
    }
    print "${not}ok $Q\n";
    $Q++;
    die "TO BIG" if $Q > 30;
}






##############################################################################
package TClient;
use strict;
use POE::Session;
use Data::Dumper;

BEGIN {
    *ok=\&main::ok;
    *DEBUG=\&main::DEBUG;
}
my $HERE="poe://YeTeste/TClient";

#########################################################
sub spawn
{
    my($package)=@_;
    POE::Session->create(
        package_states=>[
            $package, [qw(_start resp1 resp2 resp3 post done)],
        ],
    );
}



#########################################################
sub _start
{
    my($kernel, $heap)=@_[KERNEL, HEAP];
    $kernel->alias_set('TClient');
    
    $kernel->call(IKC=>'publish', 0=>[qw(resp1 resp2 resp3 resp4)]);

    $heap->{N}=1;

    $heap->{expect_step}=0;

    $kernel->yield('post', [{}, $HERE.'/resp1']);
}

#########################################################
sub post
{
    $_[KERNEL]->post(IKC=>'post', 'poe://YeTeste/Scripted/testpoint', 
                    $_[ARG0]);
}

#########################################################
sub resp1
{
    my($kernel, $form, $heap)=@_[KERNEL, ARG0, HEAP];
    die "ERROR for resp1: ", Dumper $form->{error} if $form->{error};
    die "Form isn't a hash (or is missing widgets): ", Dumper $form 
                        unless 'HASH' eq ref $form and $form->{widgets};

    DEBUG and 
        warn "=========== N=$heap->{N}, expect_step=$heap->{expect_step}\n";
    $heap->{PID}=$form->{PID};

    # TODO: do this PROPERLY
    my $input=$form->{widgets}[0];
    my $actions=$form->{widgets}[1];
    my $hidden=$form->{widgets}[2];

    if($input->[0]{content} != $heap->{expect_step}) {
        warn "content=$input->[0]{content} != expect_step=$heap->{expect_step}";
        die Dumper $input, $heap;
    }
    ok(undef(), ($input->[0]{content} == $heap->{expect_step}));

    my %buttons;
    if($actions) {                  # get hashref of actions
        my $q=0;
        foreach my $but (@{$actions->{_order}}) {
            $buttons{$q++}=$but;
            $buttons{$but}="ACTION.$but";
        }
    }

    my $back=$HERE.'/resp1';
    DEBUG and 
        warn "N=$heap->{N}, expect=$heap->{expect_step}, form=$input->[0]{content}";
    if($heap->{N} == 7) {    # DONE !
        die "Step $heap->{expect_step} shouldn't have buttons!", Dumper $form
                if keys %buttons;
        # print STDERR "\n\n\n";

        $heap->{expect_step}=0;         # start again
        $kernel->yield('post', [{}, $HERE.'/resp1']);
        $heap->{N}++;
        return;
    } 
    elsif(not keys %buttons) {
        die "Woah!  no buttons!\n", Dumper $form;
    }

    my $resp={OOB=>{PID=>$heap->{PID}}, 
              $hidden->{name}=>$hidden->{content},
              $input->[0]{name}=>$input->[0]{content}+1, 
             };

    if($heap->{N} == 3) {               # back up a step
        # Note, {N} is going to be repopulated... so it's the new N, not old
        # $heap->{expect_step}--;
        $resp->{$buttons{prev}}='Pressed';
    } 
    elsif($heap->{N} == 9) {
        # print STDERR "We want to cancel\n";
        $resp->{$buttons{cancel}}='Pressed';
        $back=$HERE.'/resp2';
    } 
    elsif(keys %buttons) {
        DEBUG and print STDERR "bumping up expect_step\n";
        $heap->{expect_step}++;
        $resp->{$buttons{next}}='Pressed';
    }

    $heap->{N}++;
    $kernel->yield('post', [$resp, $back]);
}


#########################################################
sub resp2
{
    my($kernel, $form)=@_[KERNEL, ARG0];
    ::ok(25);
    $kernel->yield('done');
}

#########################################################
sub resp3
{
    my($kernel, $items)=@_[KERNEL, ARG0];
}
#########################################################
sub resp4
{
    my($kernel, $items)=@_[KERNEL, ARG0];
}


#########################################################
sub done
{
    my($kernel, $package)=@_[KERNEL, OBJECT];
    $kernel->alias_remove('TClient');
    $kernel->post(IKC=>'shutdown');
}




##############################################################################
package Something;
use strict;

use Data::Dumper;
use JAAS::Object::Delegate;
use JAAS::Object::Services;

BEGIN {
    *ok=\&main::ok;
    *DEBUG=\&main::DEBUG;
}
use vars qw(@ISA);
BEGIN { @ISA=qw(JAAS::Object::Delegate);}

$Something::N=2;
sub new
{
    my($package, $args)=@_;
    my $self=$package->SUPER::new($args);
    $self->{N}=$Something::N;
    $Something::N=19 if $Something::N==2;
    return $self;
}

sub methods
{
    (
start_pre=>{},
start_post=>{},
one_pre=>{},
one_post=>{},
two_pre=>{},
two_post=>{},
three_pre=>{},
three_post=>{},
widgets=>{},
cancel=>{},
    )
}

#########################################################
sub start_pre
{
    my($self)=@_;
#    print STDERR "N=$self->{N}\n";
    ::ok($self->{N});   # 2, 19

    $self->{N}+=2;
    $self->{canceled}=0;
    $self->{step}=0;
    return;
}

sub start_post
{
    my($self)=@_;       
    ::ok($self->{N});   # 4, 21
    $jaas_services->post('script_add@'.$jaas_services->sender, 
                                        [qw(one two three)]);
    $self->{N}+=1;
    return;
}

#########################################################
sub one_pre
{
    my($self)=@_;

    die Dumper $self if $self->{step} != 1;
    ::ok($self->{N}, ($self->{step}==1));   # 5, 22
    $self->{N}+=2;
    return;
}

sub one_post
{
    my($self)=@_;
    ::ok($self->{N});                       # 7, 11
    $self->{N}+=1;
    return;
}

#########################################################
sub two_pre
{
    my($self)=@_;
    my $step=$self->{N} == 8 ? 2 : 3;
    ::ok($self->{N}, ($self->{step}==$step));   # 8, 12
    $self->{N}+=2;
    $self->{N}++ if $self->{N}==10;
    return;
}

sub two_post
{
    my($self)=@_;
    ::ok($self->{N});                       # 14
    $self->{N}+=1;
    return;
}

#########################################################
sub three_pre
{
    my($self)=@_;
    ::ok($self->{N}, ($self->{step}==4));   # 15
    $self->{N}+=2;
    return;
}

sub three_post
{
    my($self)=@_;
    ::ok($self->{N});                       # 17
    $self->{N}+=1;
    return;
}

#########################################################
sub cancel
{
    my($self)=@_;
    $self->{canceled}=1;
#    print STDERR "CANCEL!\n";
    ::ok($self->{N});                       # 24
    $self->{N}+=1;
    return;
}


#########################################################
sub widgets
{
    my($self)=@_;

    my @widgets;
    if($self->{canceled}) {
        # print STDERR "===== Canceled\n";
        push @widgets, [JAAS::Widget::Label->new(name=>'canceled')];
    }
    else {
        DEBUG and print STDERR "Something : step == $self->{step}\n";
        push @widgets, [JAAS::Widget::Text->new(name=>'step', 
                                          source=>$self->{name}."/step")];
    }
    return \@widgets;
}




##############################################################################
package My::Own::Cache;
use strict;
use JAAS::Object::Cache::Simple;
use Storable qw(dclone);
use vars qw(@ISA);

BEGIN {
    @ISA=qw(JAAS::Object::Cache::Simple);
    *DEBUG=\&main::DEBUG;
}

sub fetch
{
    my($self, $id, $name)=@_;
    my $data=$self->SUPER::fetch($id, $name);
    return $data unless ref $data;
    return dclone $data;
}

sub store
{
    my($self, $id, $name, $data)=@_;
    $self->SUPER::store($id, $name, dclone $data);
}

sub clear
{
    my($self, $id, $who)=@_;
    return unless exists $self->{$id}{_interested}{$who};
    delete $self->{$id}{_interested}{$who};
    # DEBUG and CORE::print "$who isn't interested in $id";

    return if keys %{$self->{$id}{_interested}};    

    # DEBUG and CORE::print "$id is FREE\n";
    return;
}







##############################################################################
package main;
use strict;
use POE::Kernel;
use JAAS::Object::Services;


JAAS::Server->spawn('multipart.conf');

TClient->spawn();

$poe_kernel->run();


END { ok(26); }
