# $Id: Group.pm,v 1.11 2002/06/07 08:26:18 fil Exp $
package JAAS::Widget::Group;

use strict;
use JAAS::Widget::Text;
use JAAS::Widget::List;

BEGIN {
    if($INC{"JAAS/Object/Services.pm"})
    { *DEBUG=sub () {JAAS::Object::Services->debug()}; }
    else { *DEBUG=sub () {0}; }
}

############################################################
sub new {
	my $class=shift @_;
    my $parm = {@_};
	my $self = {_source=>delete $parm->{_source},
		    name=>delete $parm->{name}};
	bless $self, $class;
	$self->_init($parm);
    $self->{title} ||= $self->{name};
	return $self;
}

#####################################################
sub _init {
	my ($self, $group_parm) = @_;
	$self->{_order} = delete $group_parm->{_order};
    foreach my $n (qw(orientation title)) {
        $self->{$n}=delete $group_parm->{$n};
    }
	foreach my $field (keys %$group_parm) {
		my $field_parm = $group_parm->{$field};
		my $widget = delete $field_parm->{widget};
		$field_parm->{source} = "$self->{_source}/$field";
		$field_parm->{name} = $field;
		$widget = "JAAS::Widget::$widget";
		$self->{$field} = $widget->new(%$field_parm);
	}
}

#####################################################
sub lifetime_save {
#	my ($self, $when) = @_;
#	if ($when eq 'context') {
#		return $self;
#	}
	return; 	# Skip saving, for now.
}

#####################################################
sub lifetime_restore {
#	my ($self, $when, $data) = @_;
	$_[0] = $_[2];
#	@{$self}{keys %$data}=values %$data;
}

#########################################################

sub populate {
    my ($self, $obj) = @_;
	foreach my $field (@{$self->{_order}}) {
		next unless ref $self->{$field};
        DEBUG and 
            warn "Populating $field";    
        $self->{$field}->populate($obj);
	}
}

#####################################################
sub capture {
    my ($self, $obj) = @_;
	foreach my $field (@{$self->{_order}}) {
		next unless ref $self->{$field};
    
        $self->{$field}->capture($obj);
	}
}

#####################################################
sub validate {
	my ($self, $obj) = @_;
	my @result;
	foreach my $field (@{$self->{_order}}) {
        next unless ref $self->{$field};
        push @result, $self->{$field}->validate($obj);
	}
	return @result;
}

#####################################################
sub get {
	my ($self, $field) = @_;
	return $self->{$field}->get();
}

#####################################################
sub get_source {
	my $self = shift;
	return $self->{_source};
}

#####################################################
sub get_all {
	my $self = shift;
	my %result;
	foreach my $field (keys %$self) {
		if ($field =~ /^_/ || $field eq 'name') {
			$result{$field} = $self->{$field};
		}
		else {
			my %ret = $self->{$field}->get();
			$result{$field} = \%ret;
		}
	}
	return \%result;
}
		
#####################################################
sub set {
	my ($self, %parm) = @_;
    foreach my $n (@{$self->{_order}}) {
        $self->{$n}->set(%parm);
    }
}

######################################################
sub to_mail {
	my ($self, $i18n) = @_;

    my @text;
    if($self->{title}) {
        my $title=$self->{title}->to_mail($i18n);
        warn "--$title--";
        push @text, $title, ('-' x (length($title)-1));
    }
	foreach my $n (@{$self->{_order}}) {
        next if $n eq 'title';
        unless($self->{$n}) {
            warn "No member called $n\n";
            next;
        }
        push @text, $self->{$n}->to_mail($i18n);
	}
#    return @text if wantarray;
    return join "\n", @text;
}

1;

__END__

=head1 NAME

JAAS::Widget::Group - Group of widget objects

=head1 SYNOPSIS

	use JAAS::Widget::Group;

	my $w = JAAS::Widget::Group->new(
			_source => 'user_data',
			_order => ['username', 'street', 'lang'],
			name => 'sample_widget',
			username => {widget=>'Text', title=>'User Name', validation=>['required']},
			street => {widget=>'Text', title=>'Street', validation=>[]},
			lang => {widget=>'List', title=>'Language', validation=>[],
                                type=>'single', items=>['fr:Francais', 'en:English', 'ru:Russki']});

	# Fill out the widget using data from an object
	$w->populate($something);

	# Set widget parameters (all widgets)
	$w->set(title=>'Your Name', content=>'Joe');

	# Get widget parameters
	my %parm = $w->get('username');  
	print "$parm{title}: $parm{content}\n";

	# Get all data
	my $data = $w->get_all();

	# Get source name
	my $source_name = $w->get_source();

	# Validate data
	my $val = $w->validate($obj);

	# Give widget data back to the object
	$w->capture($something);

=head1 DESCRIPTION

JAAS::Widget::Group gives you a way of grouping several widget objects (either Text or List)
under a single entity. A group can be defined using the long C<new()>
constructor or by using already defined subclasses. These subclasses (like
JAAS::Widget::Group::Address) have their own constructor that defines a set
of appropriate widgets.

=head1 METHODS

=head2 new
          
        $w = JAAS::Widget::Group->new($parameters);

Constructor. The argument is a hashref of
fields, field names for keys and init parameters for values. These last
parameters are the same as the underlying class (Text or List), with a
'widget' element added. This element should be 'Text' or 'List', to indicate
widget type.

The 'name' parameter for each field is set with the field name (hash key).
The 'source' parameter for each field is reconstructed using the group
_source and the field name in a '_source/field' syntax.

Three special fields must be included:
	_source - source object's name
	_order - display order of fields, in an arrayref
	name - Object name

If you need to construct from a subclass use:
	$w = JAAS::Widget::Group::subclass->new({_source=>$source_name, 
						 name=>$name});

Here the only parameters needed is the source object's name. Everything else
is predefined in the package.

=head2 populate

	$w->populate($obj);

Fills out the widget with data from the object C<$obj>. The component
widgets' C<name> are used to get the proper fields from the object.

=head2 capture

	$w->capture($obj);

Gives back the widget value to the object C<$obj>. Again, the component
widgets' C<name> are used for the object's fields.

=head2 set

	$w->set(%parameters);

Sets parameters for a field in ALL objects, just like C<new()> but without
having to re-initialize the objects again.

=head2 get

	%parameters = $w->get($name);

Gets all parameters from a particular field. See the doco for Text and List
for details.

=head2 get_all

	$data = $w->get_all();

Gets everything there is about the widget. Returns a hashref, keys =
individual widget names, values = widget data.

=head2 get_source

	$source_name = $w->get_source();

Gets the source object's name, as set in the constructor.

=head2 validate

	$val = $w->validate($obj);

Runs the validation routines, as listed in C<validation>, on the data in
every field from the JAAS object wrapper. Returns the results in a hashref 
containing validation messages as keys, field names as values.

=head1 AUTHOR

Philip Gwyn <jaas at awale.qc.ca>, 
Learry Gagn <mou-jaas at awale.qc.ca>.

=head1 SEE ALSO

perl(1), JAAS::Widget::Text, JAAS::Widget::List

=cut

$Log: Group.pm,v $
Revision 1.11  2002/06/07 08:26:18  fil
Bumped version
Added orientation,title to Widget::Group
Widget::Hidden can now be static :)
Widget::List item_tags is now a hashref name => tag
Widget::List checks that capture is on a value in the list of known values
Widget::Text can be multilined
Widget::Text won't capture info if static
Wiget::G::Action now has _title, a hashref of name => title pairs

Revision 1.10  2001/10/11 02:09:53  fil
Cleanup of to_mail stuff

Revision 1.9  2001/10/05 01:06:38  mou
Changed to_mail() behavior so as to eliminate the need for DBI.

Revision 1.7  2001/09/26 19:16:55  fil
Widget title defaults to same as name

Revision 1.6  2001/09/26 02:24:31  fil
Added static members, so that widgets don't get validated.

Revision 1.5  2001/08/09 03:35:43  fil
Created MANIFEST, Makefile.PL and a nominal test.
    perl Makefile.PL; make; make test; make install # now works
Added $VERSION to JAAS::Widget::List... this should be in JAAS::Widget,
the common base class of all widgets, be they lists or not.
Cleaned up param passing for JAAS::Widget::Group->new()
JAAS::Widget::Group->validate, ->capture and ->populate now use {_order}
Added comments to JAAS::Widget::List->check :)
Cleaned up validation:  No error is () or undef(), not 0.
Cleaned up POD so that it parses properly
Added JAAS::Widget::Label
Added JAAS::Widget::Group::CartItem
  