# $Id: Action.pm,v 1.4 2002/06/07 08:26:18 fil Exp $
package JAAS::Widget::Group::Action;

use strict;
use JAAS::Widget::Group;
use vars qw(@ISA);
@ISA = qw(JAAS::Widget::Group);

#####################################################
sub new {
    my($package, $buttons)=@_;
    my $self=bless {_order=>$buttons}, $package;

    foreach my $a (@$buttons) {
        next unless $a =~ /(.+?):(.+)/;
        $a=$1;
        $self->{_title}{$1}=$2;
    }
    return $self;
}

#####################################################
sub populate {
    # ignore this
}

sub capture {
    # ignore this
}

sub validate {
    # ignore this
    return;
}
sub to_mail
{
    return '';      # silly to call this 
}

#####################################################
sub lifetime_save {
    my($self, $when)=@_;
    return $self->{_order} if $when eq 'context';
    return $self->SUPER::lifetime_save($when);
}

sub lifetime_restore {
    my($self, $when, $data)=@_;
    if($when eq 'context') {
        $self->{_order}=[@$data];
    } else {
        $self->SUPER::lifetime_restore($when, $data);
    }
}


1;
	

__END__

$Log: Action.pm,v $
Revision 1.4  2002/06/07 08:26:18  fil
Bumped version
Added orientation,title to Widget::Group
Widget::Hidden can now be static :)
Widget::List item_tags is now a hashref name => tag
Widget::List checks that capture is on a value in the list of known values
Widget::Text can be multilined
Widget::Text won't capture info if static
Wiget::G::Action now has _title, a hashref of name => title pairs

Revision 1.3  2001/10/11 02:09:53  fil
Cleanup of to_mail stuff

Revision 1.2  2001/09/27 04:28:10  fil
Twiddled validation
Static CC is masked
CC numbers not saved (I hope).

Revision 1.1  2001/08/11 19:35:46  fil
Added JAAS::Widget::Group::Action

Revision 1.3  2001/08/09 03:35:43  fil
Created MANIFEST, Makefile.PL and a nominal test.
    perl Makefile.PL; make; make test; make install # now works
Added $VERSION to JAAS::Widget::List... this should be in JAAS::Widget,
the common base class of all widgets, be they lists or not.
Cleaned up param passing for JAAS::Widget::Group->new()
JAAS::Widget::Group->validate, ->capture and ->populate now use {_order}
Added comments to JAAS::Widget::List->check :)
Cleaned up validation:  No error is () or undef(), not 0.
Cleaned up POD so that it parses properly
Added JAAS::Widget::Label
Added JAAS::Widget::Group::CartItem

