# $Id: Address.pm,v 1.3 2001/08/09 03:35:43 fil Exp $
package JAAS::Widget::Group::Address;

use strict;
use JAAS::Widget::Group;
use JAAS::Widget::Text;
use JAAS::Widget::List;
use vars qw(@ISA);
@ISA = qw(JAAS::Widget::Group);

#####################################################
sub _init {
	my($self, $parm) = @_;
	my $source = $self->{_source};
	$self->{_order} = ['username', 'street', 'phone', 'lang'];
	$self->{username} = JAAS::Widget::Text->new(name=>'username', title=>'User Name',
				source=>"$source/username", validation=>['required'], class=>'red');
	$self->{street} = JAAS::Widget::Text->new(name=>'street', title=>'Street',
				source=>"$source/street", validation=>['required']);
	$self->{phone} = JAAS::Widget::Text->new(name=>'phone', title=>'Telephone',
				source=>"$source/phone", validation=>['phone']);
	$self->{lang} = JAAS::Widget::List->new(name=>'lang', title=>'Language',
				source=>"$source/lang", validation=>['required'],
				type=>'single', items=>['fr:Francais', 'en:English', 'ru:Russki']);
}

1;
	

__END__

$Log: Address.pm,v $
Revision 1.3  2001/08/09 03:35:43  fil
Created MANIFEST, Makefile.PL and a nominal test.
    perl Makefile.PL; make; make test; make install # now works
Added $VERSION to JAAS::Widget::List... this should be in JAAS::Widget,
the common base class of all widgets, be they lists or not.
Cleaned up param passing for JAAS::Widget::Group->new()
JAAS::Widget::Group->validate, ->capture and ->populate now use {_order}
Added comments to JAAS::Widget::List->check :)
Cleaned up validation:  No error is () or undef(), not 0.
Cleaned up POD so that it parses properly
Added JAAS::Widget::Label
Added JAAS::Widget::Group::CartItem

