# $Id: CartItem.pm,v 1.4 2001/10/11 02:09:53 fil Exp $
package JAAS::Widget::Group::CartItem;
use strict;

use JAAS::Widget::Group;
use JAAS::Widget::Text;

use vars qw(@ISA);
@ISA = qw(JAAS::Widget::Group);

#####################################################
sub _init {
	my($self, $parm) = @_;


    my $sku=$self->{sku}=$parm->{sku}||$parm->{SKU};

    $self->{orientation}="horizontal";
	$self->{_order} = [qw(name price quantity total)];

	$self->{name} = JAAS::Widget::Label->new(name=>"name", 
                            title=>$parm->{title});
	$self->{price} = JAAS::Widget::Text->new(name=>"price",
					class=>'money',
            				source=>$parm->{price_source});
	$self->{quantity} = JAAS::Widget::Text->new(
                            name=>$sku, validation=>['quantity'],
            				source=>$parm->{source});
	$self->{total} = JAAS::Widget::Text->new(name=>"item_total",
                                        class=>'money',
                                        source=>$parm->{total_source});

}

sub to_mail {		# Specific display format
    my ($self, $i18n) = @_;
	my $text = $self->{quantity}->{content}." ";
	$text .= $self->{name}->to_mail($i18n);
	$text .= '.' x (45-length($text));
	$text .= " ". $self->{price}->to_mail($i18n);
	$text .= " -- ". $self->{total}->to_mail($i18n);	
	return $text;
}	

1;
	

__END__

$Log: CartItem.pm,v $
Revision 1.4  2001/10/11 02:09:53  fil
Cleanup of to_mail stuff

Revision 1.3  2001/10/04 20:02:36  mou
Mail Conversion via to_mail().
Added to_money() to Text widgets.
Added total (Text) widget to Group/CartItem.

Revision 1.2  2001/09/18 20:05:51  fil
Foo

Revision 1.1  2001/08/09 03:35:43  fil
Created MANIFEST, Makefile.PL and a nominal test.
    perl Makefile.PL; make; make test; make install # now works
Added $VERSION to JAAS::Widget::List... this should be in JAAS::Widget,
the common base class of all widgets, be they lists or not.
Cleaned up param passing for JAAS::Widget::Group->new()
JAAS::Widget::Group->validate, ->capture and ->populate now use {_order}
Added comments to JAAS::Widget::List->check :)
Cleaned up validation:  No error is () or undef(), not 0.
Cleaned up POD so that it parses properly
Added JAAS::Widget::Label
Added JAAS::Widget::Group::CartItem

