package JAAS::Widget::Header;

use strict;

use vars qw($VERSION @ISA);
$VERSION="0.01";

BEGIN {
    if($INC{"JAAS/Object/Services.pm"})
    { *DEBUG=sub () {JAAS::Object::Services->debug()}; }
    else { *DEBUG=sub () {0}; }
}

use JAAS::Widget::Text;
@ISA=qw(JAAS::Widget::Text);

##################################################
sub new {
	my $class = shift;
	my %parm = @_;
	my $self = {
		name => '',
		title => '',
        width => 2,
        class => '',
        static => 0,
        'no-title'=> 0,
	};
	bless $self, $class;
	$self->set(%parm);

	return $self;
}

#################################################
# Accessors

sub populate {return}
sub capture {return}
sub to_mail 
{
    my($self, $i18n)=@_;
    return unless $self->{title};
    my $n=$i18n->get(($self->{title}||'title'), $self->{bits});
    return join "\n", $n, ('-' x length $n);
}

#############################################
# Validation
sub validate {return}

1;

__END__

=head1 NAME

JAAS::Widget::Header - widget object for dialog box headers and extra info

=head1 SYNOPSIS

	use JAAS::Widget::Header;

	my $w = JAAS::Widget::Header->new(name=>'something',
                                      content=>$something);

=head1 DESCRIPTION

This widget is used for passing information about a group of parameters.  This
information should be used for display purposes.  It does not define a widget
that inputs data.

=head1 METHODS

=head2 new
	
	$w = JAAS::Widget::Header->new(%parameters);

Constructor. The parameters can be any of the following:

=over 4

=item name

Unique name for the dialog box.

=item title

Unique title for the dialog box.

=item class

I18N class to overide current one.

=item width

Number of columns in the dialog box.  Defaults to 2.

=back

=head1 AUTHOR

Philip Gwyn <jaas at awale.qc.ca>, 
Learry Gagn <mou-jaas at awale.qc.ca>.

=head1 SEE ALSO

JAAS::Widget::Text, perl(1).

=cut
