package JAAS::Widget::Hidden;

use strict;

use vars qw($VERSION @ISA);
$VERSION="0.01";

BEGIN {
    if($INC{"JAAS/Object/Services.pm"})
    { *DEBUG=sub () {JAAS::Object::Services->debug()}; }
    else { *DEBUG=sub () {0}; }
}

use JAAS::Widget::Text;
@ISA=qw(JAAS::Widget::Text);

##################################################
sub new {
	my $class = shift;
	my %parm = @_;
	my $self = {
		name => '',
		content => '',
        static=>0,
	};
	bless $self, $class;
	$self->set(%parm);

	return $self;
}

#################################################
# Accessors
# content must be set at instantiation time... 
# This might be bad.
sub populate {}
# Can't ever modify the value, eh...
sub capture {}

sub to_mail {return}

#############################################
# Validation

sub validate {return}

1;

__END__

=head1 NAME

JAAS::Widget::Hidden - Hidden widget object

=head1 SYNOPSIS

	use JAAS::Widget::Hidden;

	my $w = JAAS::Widget::Hidden->new(name=>'something',
                                      content=>$something);

=head1 DESCRIPTION

This widget is used for "hiding" information in a form.  This is probably
the wrong way to go about this, because it's probably tied to HTML...

=head1 METHODS

=head2 new
	
	$w = JAAS::Widget::Hidden->new(%parameters);

Constructor. The parameters can be any of the following:

=over 4

=item name

Unique field name.

=item content

Widget value.

=back

=head1 AUTHOR

Philip Gwyn <jaas at awale.qc.ca>, 
Learry Gagn <mou-jaas at awale.qc.ca>.

=head1 SEE ALSO

JAAS::Widget::Text, perl(1).

=cut
