package JAAS::Widget::Label;

use strict;
use JAAS::Widget::Text;

sub DEBUG {0};

use vars qw(@ISA);
@ISA=qw(JAAS::Widget::Text);

##################################################
sub new {
	my $class = shift;
	my %parm = @_;
	my $self = {
		name => '',
		title => '',
		class => '',
        bits => ''
	};
	bless $self, $class;
	$self->set(%parm);
    $self->{title} ||= $self->{name};
	return $self;
}

#################################################
# Accessors

sub populate {
#	my ($self, $obj) = @_;
    return;             # do nothing
}

sub capture {
#	my ($self, $obj) = @_;
    return;             # do nothing
}
sub to_mail {
    my($self, $i18n) = @_;
    return $i18n->get($self->{title}, $self->{title}, $self->{bits});
}

#############################################
# Validation

sub validate {
#	my ($self, $obj) = @_;
    return;             # do nothing
}

1;

__END__

=head1 NAME

JAAS::Widget::Label - Text label widget object

=head1 SYNOPSIS

	use JAAS::Widget::Label;

	my $w = JAAS::Widget::Text->new(
                                title=>'Credit Card');

=head1 DESCRIPTION

=back

=head1 AUTHOR

Philip Gwyn <jaas at awale.qc.ca>, 
Learry Gagn <mou-jaas at awale.qc.ca>.

=head1 SEE ALSO

perl(1).

=cut
