    
## $Id: CC.pm,v 1.1 2001/09/24 22:35:16 fil Exp $
## $Log: CC.pm,v $
## Revision 1.1  2001/09/24 22:35:16  fil
## Added credit card stuff
##
## Revision 1.1  1998/08/13 02:03:13  wcamelot
## Initial revision
##
# Revision 1.1  1998/04/23  06:10:39  Dread_fil
# Initial revision
#

package JAAS::Widget::Text::CC;
use strict;

use vars qw(@ISA @EXPORT_OK $VERSION %Types);
$VERSION=0.01;
require Exporter;
@ISA=qw(Exporter);
@EXPORT_OK=qw(check_cc cc_mask check_expiry check_holder cc_issuer cc_chksum cc_canon);

%Types=(MC=>'Master Card',
        VISA=>'Visa',
        AMEX=>'American Express',
        DISC=>'Discover',
        DCCB=>"Diner's Club/Carte Blanche",
        enRoute=>'enRoute',
        JCB=>'JCB',
        BC=>'BankCard',
        UNKNOWN=>'Unknown',
        );

#######################################################
## Make sure a CC number if valid
sub check_cc ($)
{
    my($cc)=@_;
    return 0 unless $cc;

    $cc=~s/[ \r\n\t\-,;:.]//g;              # strip junk
    return 0 unless $cc=~/^[0-9]{13,30}$/;  # simple check
    return 0 if cc_issuer($cc) eq 'UNKNOWN';
    return 0 unless cc_chksum($cc) eq substr($cc, -1);

    return 1;
}

#######################################################
## Make sure the CC expiry that is valid
## If passed a reference, we change it to the canonical form (MM/YY)
sub check_expiry ($;$)
{
    my($ex, $date)=@_;

    return 0 unless $ex;
    my $expiry=(ref $ex) ? $$ex : $ex;
    return 0 unless $expiry;

    $expiry=~s/ //g;
    if( $expiry=~/^([0-9]{1,2})[\\\/\-.]([0-9]{2})$/ or
            $expiry=~/^([0-9]{2})([0-9]{2})$/)
    {
        my ($mon, $year)=(0+$1, 0+$2);
        if(0<$mon and $mon<=12)             # a simple sanity test
        {
            if($date)
            {
                my @now=localtime;
                my $y=$year;
                $y+=100 if $y<50;           # Y2K!!!!
                return 0 if ($y < $now[5]);
                return 0 if ($y == $now[5] and $mon < $now[4]);
                        # Yes, I realise it should be $mon <= $now[4], but
                        # this is a bit more lenient
            }
            if(ref $ex)                     # caller wants a better looking
            {   $mon="0$mon" if($mon<10);   # form back... kewl
                $year="0$year" if($year<10);
                $$ex="$mon/$year";
            }
            return 1;
        }
    }
    return 0;
}

#######################################################
## Verify a CC holder is valid
## Not much we can check here, just a place holder in case
## I think of something...
sub check_holder ($)
{
    my($holder)=@_;
    return 0 unless $holder;            # WOW!  What far freaken checking!
    return 0 unless $holder=~/^[a-zA-Z \.\-]+$/;
    return 1;
}

#######################################################
## Find out the issuer of a credit card
sub cc_issuer ($)
{
    ($_)=@_;
    s/[ \r\n\t\-,;:.]//g;              # strip junk
    if(/^5[1-5]\d{14}$/)
    {   return 'MC';    }
    if(/^4\d{12}$/ or /^4\d{15}$/)
    {   return 'VISA';  }
    if(/^3[47]\d{13}$/)
    {   return 'AMEX';  }
    if(/^6011\d{12}$/)
    {   return 'DISC';  }
    if(/^3[68]\d{12}$/ or /^30[05]\d{11}$/)
    {   return 'DCCB';  }
    if(/^(?:2014|2149)\d{11}$/)
    {   return 'enRoute';   }
    if(/^(?:2131|1800)\d{11}$/ or /^3\d{15}$/)
    {   return 'JCB';   }
    if(/^56(10\d\d|022[1-5])\d{10}$/) 
    { return "BC";      }
    return 'UNKNOWN';
}

#######################################################
## Make sure the check sum is valid
sub cc_chksum ($)
{
    my($cc)=@_;
    $cc=~s/[ \r\n\t\-,;:.]//g;              # strip junk

    if(0)
    {
        my ($i, $weight, $sum, $l);
        $l=length $cc;
        for ($i = 0; $i < $l - 1; $i++)
        {
	        $weight = substr($cc, -1 * ($i + 2), 1) * (2 - ($i % 2));
    	    $sum += (($weight < 10) ? $weight : ($weight - 9));
        }
        return 1 if substr($cc, -1) == (10 - $sum % 10) % 10;
        return 0;
    }

    my ($dd, $t, $total);
    my @dd=split //, $cc;
    return 0 unless @dd;
    my $flip=not (1 & scalar(@dd));
    # print "$flip ", scalar(@dd), "\n";
    my $last=pop @dd;
    foreach $dd (@dd)
    {
        if($flip)
        {
            $t=$dd*2;
            $t-=9 if $t>=10;
            $total+=$t;
        } else
        {
            $total+=0+$dd;
        }
        $flip=not $flip;
        # print "$total\n";
    }
    # warn "$total : ", 10-($total%10);
    $total=(10-($total%10))%10;
    return ($total, $last) if wantarray;
    return $total;
}

#######################################################
## Convert a CC number to canonical form
sub cc_canon ($)
{
    my($cc)=@_;
    $cc=~s/\D+/ /g;     # all runs of non-digit becomes one space
    $cc=~s/^ //;        # trim leading space
    $cc=~s/ $//;        # trim trailing
    return $cc;
}

*canon=\&cc_canon;
*issuer=\&cc_issuer;
*chksum=\&cc_chksum;


#######################################################
## Mask out most of the CC number
sub cc_mask
{
    my($cc)=@_;
    if(not $cc)
    {
        # die "Hey!  no cc number";
        return '';
    }
    $a=index($cc, ' '); 
    $a=4 if $a<0 or  $a>4;
    $b=(rindex($cc, ' ')-$a); 
    $b=length($cc)-3-$a if $b<0 or length($cc)-$b-$a > 3;
    # warn "$a, $b, ", length($cc), ', ', length($cc)-$b-$a;
    substr($cc, $a, $b) =~ tr/0-9/x/;
    # die $cc;
    return $cc;
}
*mask=\&cc_mask;

1;
