package JAAS::Widget::Text::CreditCard;

use strict;

use JAAS::Widget::Text;
use JAAS::Widget::Text::CC qw(check_cc check_expiry check_holder cc_mask cc_issuer);
use vars qw($VERSION @ISA);
$VERSION="0.01";

BEGIN {
    if($INC{"JAAS/Object/Services.pm"})
    { *DEBUG=sub () {JAAS::Object::Services->debug()}; }
    else { *DEBUG=sub () {0}; }
}

@ISA=qw(JAAS::Widget::Text);

##################################################
sub set
{
    my($self, %params)=@_;
    $self->SUPER::set(%params);
    $self->{is_creditcard}=grep /^creditcard$/, @{$self->{validation}};
}

##################################################
sub creditcard {
    my $self = shift;
    return if check_cc($self->{content});
    return 'CREDITCARD';
}

sub expiry {
    my $self = shift;
    return if check_expiry(\$self->{content});
    return 'INVALID';
}

sub holder {
    my $self = shift;
    return if check_holder($self->{content});
    return 'INVALID';
}

sub cardtype {
    my($self, $types)=@_;
    my $type=cc_issuer($self->{content});
    warn "$self->{content} is a $type";
    foreach my $t (split ',', $types) {
        return if $type eq $t;
    }
    return "NOTACCEPTED.$type";
}

##################################################
sub populate
{
    my($self, $obj)=@_;
    $self->SUPER::populate($obj);
    return unless $self->{static} and $self->{is_creditcard};
    # mask all static credit card numbers
    $self->{static_content}=cc_mask($self->{content});
    
}

##################################################
sub validate
{
    my($self, $obj)=@_;
    local $self->{static}=$self->{static};

    # if we had a hidden input field, we want to capture it
    if($self->{static} and $self->{is_creditcard}) {
        DEBUG and warn "Static credit card validation";
        $self->{static}=0;
    }
    # yow! if the field somehow changes, it'll blow up BIG time :/
    $self->SUPER::validate($obj);
    
}

##################################################
sub capture
{
    my($self, $obj)=@_;
    local $self->{static}=$self->{static};

    # if we had a hidden input field, we want to capture it
    if($self->{static} and $self->{is_creditcard}) {
        DEBUG and warn "Static credit card capture, ";
        $self->{static}=0;
    }
    $self->SUPER::capture($obj);
    
}

##################################################
sub persist_save
{
    my($self)=@_;
    return $self unless $self->{is_creditcard};
    my $dup;
    @{$dup}{keys %$self}=values %$self;
    $dup->{content}='';
    bless $dup, ref $self;
    return $dup;
}

1;

__END__

$Log: CreditCard.pm,v $
Revision 1.5  2002/11/05 20:57:52  fil
Added code to contrain type of credit card

Revision 1.4  2001/10/11 02:09:54  fil
Cleanup of to_mail stuff

Revision 1.3  2001/09/27 04:28:10  fil
Twiddled validation
Static CC is masked
CC numbers not saved (I hope).

