package JAAS::Widget::Text::PC;
#$Id: PC.pm,v 1.2 2001/10/11 03:14:29 mou Exp $

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;

@ISA = qw(Exporter);
@EXPORT_OK = qw(
	
);
$VERSION = '0.01';


########################################################################
use vars qw(%First %Equiv %rFirst $firstLetter);
%Equiv=(
    'Alberta'               =>'AB',
    'British Columbia'      =>'BC',
    'Colombie Britannique'  =>'BC',
    'Manitoba'              =>'MB',
    'New Brunswick'         =>'NB',
    'Nouveau-Brunswick'     =>'NB',
    'Newfoundland'          =>'NF',
    'Terre-Neuve'           =>'NF',
    'Nouvelle-Ecosse'       =>'NS',
    "Nouvelle-\xC9cosse"    =>'NS',
    'Nova Scotia'           =>'NS',
    'Ontario'               =>'ON',
    'Ile-du-Prince-Edouard' =>'PE',
    "\xcele-du-Prince-\xC9douard" =>'PE',
    'Prince Edward Island'  =>'PE',
    'PEI'                   =>'PE',
    'Quebec'                =>'QC',
    "Qu\xe9bec"             =>'QC',
    'Saskatchewan'          =>'SK',
    'Yukon'                 =>'YT',
    'NWT'                   =>'NT',
    'TNW'                   =>'NT',
    'Hors Canada'           =>'HC',
    'Outside Canada'        =>'HC',
    'Canada'                =>'CA',
);

%First=(
    'AB'=>{T=>1,},
    'BC'=>{V=>1,},
    'MB'=>{R=>1,},
    'NB'=>{E=>1,},
    'NF'=>{A=>1,},
    'NS'=>{B=>1,},
    'ON'=>{K=>1, L=>1, M=>1, N=>1, P=>1,},
    'PE'=>{C=>1,},
    'QC'=>{G=>1, H=>1, J=>1,},
    'SK'=>{S=>1,},
    'YT'=>{Y=>1,},
    'NT'=>{X=>1,},
);

foreach my $prov (keys %First)
{
    foreach my $letter (keys %{$First{$prov}})
    {
        $rFirst{$letter}=$prov;
    }
}
$firstLetter=join '', keys %rFirst;

########################################################################
sub is_valid
{
    my($pc)=@_;
    return unless $pc;
    $pc=~s/\W//g;
    $pc=uc $pc;
    if($pc=~/([$firstLetter]\d[A-Z])(\d[A-Z]\d)/)
    {
        return "$1 $2";
    }
    return;
}

########################################################################
sub in_province
{
    my($pc)=@_;
    return unless defined $pc;
    return $rFirst{uc substr($pc, 0, 1)};
}

########################################################################
sub right_province
{
    my($pc, $prov)=@_;
    return unless defined $pc and defined $prov;
    $prov=$Equiv{$prov} if exists $Equiv{$prov};
    return unless exists $First{$prov};
    return $First{$prov}->{substr($pc, 0, 1)};
}


1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

CA::PostalCode - Perl extension for blah blah blah

=head1 SYNOPSIS

  use CA::PostalCode;
  blah blah blah

=head1 DESCRIPTION

This is here temporarly until I create Business::CA::PostalCode or something.

=head1 AUTHOR

Philip Gwyn <jaas at awale.qc.ca>, 
Learry Gagn <mou-jaas at awale.qc.ca>.

=head1 SEE ALSO

perl(1).

=cut

