package JAAS::Widget::Text::PostalCode;

use strict;

use JAAS::Widget::Text;
use JAAS::Widget::Text::PC;

use vars qw($VERSION @ISA);
$VERSION="0.01";

BEGIN {
    if($INC{"JAAS/Object/Services.pm"})
    { *DEBUG=sub () {JAAS::Object::Services->debug()}; }
    else { *DEBUG=sub () {0}; }
}

@ISA=qw(JAAS::Widget::Text);

##################################################
sub set
{
    my($self, %params)=@_;
    $self->{province_name}='' unless exists $self->{province_name};
    $self->SUPER::set(%params);
}

##################################################
sub validate
{
    my($self, $obj)=@_;

    # we also want to grab province info for validation
    unless($self->{static}) {
        $self->{_province} = $self->{province_name} 
                                ? $obj->param($self->{province_name})
                                : '' ;
    }

    $self->SUPER::validate($obj);
    
}

##################################################
sub pcode 
{
	my($self, $province) = @_;
    return unless $self->{content} and $self->{content} =~ /\S/;
    return if     $self->{content} =~ /\d{8}(-\d{5})?/; # USA

    # Canada
    my $q=JAAS::Widget::Text::PC::is_valid($self->{content});
    unless($q) {
        DEBUG and 
            warn "$self->{content} isn't in US nor valid CA\n";
        return 'PCODE';
    }

    $province||=$self->{_province};

    if($province and not 
          JAAS::Widget::Text::PC::right_province($self->{content}, $province)) {

        DEBUG and 
            warn "$self->{content} isn't in $province\n";
        return 'PROVINCE.PCODE';
    }
    $self->{content}=$q;

    # TODO: Only Canada and USA allowed... what about Europe?
    return;
}


1;

__END__

$Log: PostalCode.pm,v $
Revision 1.2  2001/11/14 06:00:09  fil
Added zip code support to pcode.

Revision 1.1  2001/10/11 02:11:31  fil
Added postal code stuff

