#!/usr/bin/perl -w
# $Id: 00_coverage.t,v 1.7 2001/10/11 02:09:54 fil Exp $

use strict;

BEGIN { $| = 1; print "1..14\n"; }

use JAAS::Widget::Text;
use JAAS::Widget::Text::CreditCard;
use JAAS::Widget::Text::PostalCode;
use JAAS::Widget::Label;
use JAAS::Widget::List;
use JAAS::Widget::Header;
use JAAS::Widget::Hidden;
use JAAS::Widget::Group;
use JAAS::Widget::Group::Address;
use JAAS::Widget::Group::CartItem;
use JAAS::Widget::Group::Action;

my $loaded = 1;
END {print "not ok 1\n" unless $loaded;}
print "ok 1\n";

my @widgets;
push @widgets, JAAS::Widget::Text->new() or print "not ";
print "ok 2\n";
push @widgets, JAAS::Widget::Text::CreditCard->new() or print "not ";
print "ok 3\n";
push @widgets, JAAS::Widget::Label->new() or print "not ";
print "ok 4\n";
push @widgets, JAAS::Widget::List->new() or print "not ";
print "ok 5\n";
push @widgets, JAAS::Widget::Group->new() or print "not ";
print "ok 6\n";
push @widgets, JAAS::Widget::Group::Address->new(_source=>'foo') or print "not ";
print "ok 7\n";
push @widgets, JAAS::Widget::Group::CartItem->new() or print "not ";
print "ok 8\n";
push @widgets, JAAS::Widget::Group::Action->new() or print "not ";
print "ok 9\n";
push @widgets, JAAS::Widget::Hidden->new() or print "not ";
print "ok 10\n";
push @widgets, JAAS::Widget::Header->new() or print "not ";
print "ok 11\n";
push @widgets, JAAS::Widget::Text::PostalCode->new() or print "not ";
print "ok 12\n";
push @widgets, JAAS::Widget::Text::CreditCard->new() or print "not ";
print "ok 13\n";

foreach my $w (@widgets) {
    $w->set(static=>1);
}
print "ok 14\n";
