package test::ClientHTML;

use strict;

use POE;
use POE::Component::IKC::Client;
use POE::Component::IKC::Responder;
use JAAS::Widget::Group::Address;
use JAAS::Widget::Group;

my $NAME = "Widget-Client$$";
my ($result, $id, $widget, $form_data);

sub get {
	my $package = shift;
	($id, $widget) = @_;
	create_ikc_client (port=>31337, name=>$NAME, subscribe=>[qw(poe://Server/Context)]);

	POE::Session->new(_start=>\&_start1,
                          _stop=>\&_stop1, 
                          _register=>\&_register1,
                          get_widget=>\&get_widget);

	$poe_kernel->run();
	return $result;
}

sub set {
	my $package = shift;
	($id, $widget, $form_data) = @_;
	create_ikc_client (port=>31337, name=>$NAME, subscribe=>[qw(poe://Server/Context)]);

	POE::Session->new(_start=>\&_start2,
	                  _stop=>\&_stop2,  
	                  _register=>\&_register2,
			  get_widget=>\&get_widget2,
	                  save_data=>\&save_data);

        $poe_kernel->run();
	return $result;
}

############################################################
# get() sequence

sub _start1 {
        my ($kernel, $heap)=@_[KERNEL, HEAP];
        $kernel->alias_set('get');
        create_ikc_responder();  
        $kernel->post('IKC', 'monitor', 'poe://Server/Context', {register=>'_register'});
}

sub _stop1 {
#        print "_stop reached\n";
}

sub _register1 {
	my $kernel = $_[KERNEL];
        $kernel->call('IKC', 'call', 'poe://Server/Context/get',
 		{id=>$id, obj=>$widget, name=>$NAME}, 'poe:/get/get_widget');
}

sub get_widget {
        my ($kernel, $w)=@_[KERNEL, ARG0];
	$result = $w->get_all();
        $kernel->post('IKC', 'post', 'poe://Server/Context/putback',
 	        {id=>$id, obj=>$widget, name=>$NAME, in=>$w});
	$kernel->post('IKC', 'shutdown');
}

################################################################
# set() sequence

sub _start2 {
        my ($kernel, $heap)=@_[KERNEL, HEAP];
        $kernel->alias_set('set');
        create_ikc_responder();  
        $kernel->post('IKC', 'monitor', 'poe://Server/Context', {register=>'_register'});
}

sub _stop2 {
#        print "_stop reached\n";
}

sub _register2 {
        my $kernel = $_[KERNEL];
        $kernel->call('IKC', 'call', 'poe://Server/Context/get',
 		{id=>$id, obj=>$widget, name=>$NAME}, 'poe:/set/get_widget');
}

sub get_widget2 {
	my ($kernel, $heap, $w)=@_[KERNEL, HEAP, ARG0];
	$heap->{widget_obj} = $w;
	my $source_name = $w->get_source();
	$heap->{source} = $source_name;
	$kernel->call('IKC', 'call', 'poe://Server/Context/get',
 		{id=>$id, obj=>$source_name, name=>$NAME}, 'poe:/set/save_data');
}

sub save_data {
	my ($kernel, $heap, $source)=@_[KERNEL, HEAP, ARG0];
	my $w = $heap->{widget_obj};
	my $source_name = $heap->{source};
	$result = $w->set_from_cgi($form_data);
	$w->capture($source);
        $kernel->post('IKC', 'post', 'poe://Server/Context/putback',
                {id=>$id, obj=>$widget, name=>$NAME, in=>$w});  
        $kernel->post('IKC', 'post', 'poe://Server/Context/putback',
 	        {id=>$id, obj=>$source_name, name=>$NAME, in=>$source});
        $kernel->post('IKC', 'shutdown');
}

1;
__END__

=head1 NAME

test::ClientHTML - POE/IKC client for HTML form generation and
capture

=head1 SYNOPSIS

	# get widget fields
	$parm = test::ClientHTML->get($id, $widget);

	# fill widget with CGI data
	$valid = test::ClientHTML->set($id, $widget, \%ARGS);

=head1 DESCRIPTION

test::ClientHTML is a POE IKC client used to get/set a widget object
via JAAS::Object::Context. It is intended to be used by a perl script
generating HTML, such as HTML::Mason components, altough it can be called
outside of an HTML environnement just as well.

ClientHTML requires a running Context server containing a widget object
along with its object data source. For now, the server must be named
"poe://Server/Context".

=head1 METHODS

=head2 get

	$parm = test::ClientHTML->get($id, $widget);

Gets all fields from a widget. This in effect calls a C<get_all()> on the
widget object. C<$id> is the Context session ID. Currently, C<$widget> is
the name of the widget group object, for example for a
JAAS::Widget::Group::Address object, C<$widget> is 'Address'.

Returns a hashref of widget fields. See JAAS::Widget::Group, method
C<get_all()> for details.

=back

=head2 set

	$valid = test::ClientHTML->set($id, $widget, \%ARGS);

Fill widget with values. C<$id> and C<$widget> have the same as above. The
C<ARGS> hashref must respect the standard CGI format. For instance, this is
fully compatible with HTML::Mason's C<%ARGS> variable. This method invokes, in
order, the C<set_from_cgi()> and C<capture()> methods in JAAS::Widget::Group.
This last method is called without arguments, so the object that was passed
with the original C<populate()> method will be used.

Returns a hashref of validation messages. Refer to JAAS::Widget::Group,
method C<validate()> for details.

=back

=head1 BUGS

Well... this is really intended as a proof of concept...

mod_perl's code caching doesn't mix well with POE/IKC. It seems to keep the
client alive even when it should have shut down (i.e. $poe_kernel->run()
returns). Be prepared to restart Apache often.

=head1 AUTHOR

Philip Gwyn <jaas at awale.qc.ca>, 
Learry Gagn <mou-jaas at awale.qc.ca>.

=head1 SEE ALSO

perl(1), JAAS::Object::Context, JAAS::Widget::Group

=cut


