package JAAS::Widget::LiteHTML;

use strict;
use POE::Component::IKC::ClientLite;
use JAAS::Widget::Group::Address; 
use JAAS::Widget::Group;

my $NAME = "Widget-Client$$";

sub get {
	my $package = shift;
	my ($id, $widget) = @_;
	my $poe = create_ikc_client(port=>31337, name=>$NAME);
	die POE::Component::IKC::ClientLite::error() unless $poe;

	my $w = $poe->call('poe://Server/Context/get', 
			{id=>$id, obj=>$widget, name=>$NAME});
	my $result = $w->get_all();
	$poe->post('poe://Server/Context/putback', {id=>$id, obj=>$widget, name=>$NAME, in=>$w});

	return $result;
}

sub set {
        my $package = shift;
	my ($id, $widget, $form_data) = @_;
	my $poe = create_ikc_client(port=>31337, name=>$NAME);
	die POE::Component::IKC::ClientLite::error() unless $poe;

	my $w = $poe->call('poe://Server/Context/get',
	                {id=>$id, obj=>$widget, name=>$NAME});
	my $source_name = $w->get_source();
	my $source = $poe->call('poe://Server/Context/get',
        		{id=>$id, obj=>$source_name, name=>$NAME});
	my $result = $w->set_from_cgi($form_data);
	$w->capture($source);
	$poe->post('poe://Server/Context/putback', {id=>$id, obj=>$widget, name=>$NAME, in=>$w});
	$poe->post('poe://Server/Context/putback', {id=>$id, obj=>$source_name, name=>$NAME, in=>$source});

	return $result;
}

