#!/usr/bin/perl -w

use strict;
use lib qw(.. /home/mou/artware/jaeca/
            /home/fil/prive/lib
            /home/fil/prive/perl5lib/lib/site_perl
            /home/fil/work/JAECA/JAAS/perl5lib/lib/site_perl);

use POE;
use POE::Component::IKC::Server;
use POE::Component::IKC::Responder;
use JAAS::Config;
use JAAS::Factory;
use JAAS::Object::Lifetime;
use JAAS::Object::Context;
use JAAS::Object::Cache::Persistant;
use Data::Squirrel::File;
use JAAS::Widget::Group::Address;

use test::Dummy;

my $ID = "UserSession";
my $NAME = "Server$$";

my $life = JAAS::Object::Lifetime->new(
		key=>$ID, context=>{tie=>'Data::Squirrel::File',
				    Directory=>'./cache',
				    LockDirectory=>'./lock'});

my $cache = JAAS::Object::Cache::Persistant->new($life);

my $config = JAAS::Config->new("config-file");
my $factory = JAAS::Factory->new($config);

JAAS::Object::Context->spawn('Context', $factory, $cache);
POE::Component::IKC::Server->spawn(port=>31337, name=>'Server');
$cache->setup($ID, $NAME);

print "Running Context...\n";
$poe_kernel->run();
print "Exiting Context...\n";
$cache->clear($ID, $NAME);