#!/usr/bin/perl -w

use strict;
use lib qw(.. /home/mou/artware/jaeca/
            /home/fil/prive/lib
            /home/fil/prive/perl5lib/lib/site_perl
            /home/fil/work/JAECA/JAAS/perl5lib/lib/site_perl);

use POE;
use POE::Component::IKC::Client;
use POE::Component::IKC::Responder;
use test::Dummy;
use JAAS::Widget::Group::Address;

my $ID = "UserSession";
my $NAME = "UserClient";

create_ikc_client (port=>31337, name=>$NAME, subscribe=>[qw(poe://Server/Context)]);

POE::Session->new (
	_start=>\&cl_start,
	_stop=>\&cl_stop,
	register=>\&cl_register,
	get_user=>\&get_user,
	fill_user=>\&fill_user,
	fill_widget=>\&fill_widget
);

print "$$: Running Client...\n";
$poe_kernel->run();
print "$$: Exiting Client...\n";
############################################################
sub cl_start {
        my ($kernel, $heap)=@_[KERNEL, HEAP];
        $kernel->alias_set('me');
        create_ikc_responder();  
        $kernel->post('IKC', 'monitor', 'poe://Server/Context', 
                                        {register=>'register'});
}

sub cl_stop {
        print "_stop reached\n";
}

sub cl_register {
	my ($kernel, $name)=@_[KERNEL, ARG1];
	print "$$: - Connected to $name\n";
	$kernel->post(IKC=>'post', 'poe://Server/Context/setup'=>{id=>$ID, name=>$NAME});
	$kernel->yield('get_user');
}

###########################################################
sub get_user {
	my $kernel = $_[KERNEL];
        $kernel->call('IKC', 'call', 'poe://Server/Context/get',
                {id=>$ID, obj=>'user', name=>$NAME}, 'poe:/me/fill_user');
}

sub fill_user {
	print "$$: Fill reached\n";
        my ($kernel, $heap, $user)=@_[KERNEL, HEAP, ARG0];
	$heap->{user_obj} = $user;
    unless(ref $user) {
        die "Can't get user: $user\n";
    }



	my $data = $user->get_field('username');
	print "user-obj: before setting: username = $data\n";
	$user->set_field('username', 'Mou');
	$user->set_field('street', '123 Street');
	$user->set_field('phone', '555-1234');
	$user->set_field('lang', ['en']);
        $kernel->call('IKC', 'call', 'poe://Server/Context/get',
                {id=>$ID, obj=>'address', name=>$NAME}, 'poe:/me/fill_widget');
}

sub fill_widget {
        my ($kernel, $heap, $w)=@_[KERNEL, HEAP, ARG0];
	print "$$: ", ref($w), "\n";
	my $user = $heap->{user_obj};               
        $w->populate($user);	
        $kernel->post('IKC', 'post', 'poe://Server/Context/putback',
                {id=>$ID, obj=>'address', name=>$NAME, in=>$w});
	$kernel->post('IKC', 'post', 'poe://Server/Context/putback',
		{id=>$ID, obj=>'user', name=>$NAME, in=>$user});	
        $kernel->post('IKC', 'shutdown');
}
