# $Id: 10_config.t,v 1.3 2001/11/14 04:32:42 fil Exp $
use strict;
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..14\n"; }
use JAAS::Config;
use Data::Dumper;

my $loaded = 1;
END {print "not ok 1\n" unless $loaded;}
print "ok 1\n";

#####################################################
my $conf=JAAS::Config->new('t/test1.conf');
print $conf ? '' : 'not ';
print "ok 2\n";
# die Dumper \%INC;
die $@ unless $conf;



#####################################################
my $biff=$conf->get(qw(foo bar biff));
die Dumper $conf unless $biff;
print $biff ? '' : 'not ';
print "ok 3\n";

if(ref $biff) {
    # warn Dumper $biff;
    print 3==@$biff ? '' : 'not ';
    print "ok 4\n";

    print 3==$biff->[2] ? '' : 'not ';
    print "ok 5\n";

    $conf->set("foo", "bar", "biff", 4);
    my $biff=$conf->get(qw(foo bar biff));
    print ref($biff) ? '' : 'not ';
    print "ok 6\n";

    print 4==@$biff ? '' : 'not ';
    print "ok 7\n";
    
}
else {
    print "not ok 4\nnot ok 5\nnot ok 6\nnot ok 7\n";
}


#####################################################
my $merchant=$conf->for('Merchant');
print $merchant ? '' : 'not ';
print "ok 8\n";
print 'JAECA::Merchant' eq $merchant->{class} ? '' : 'not ';
print "ok 9\n";


#####################################################
$conf=new JAAS::Config;
$conf->default("Something", 'foo');

my $q=$conf->get('Something');
die Dumper $conf unless $q;
print $q eq 'foo' ? '' : 'not ';
print "ok 10\n";

$conf->load('t/test1.conf');
$q=$conf->get('Something');
print $q eq 'foo' ? '' : 'not ';
print "ok 11\n";

$conf->load('t/test4.conf');
$q=$conf->get('Something');
print $q eq 'bar' ? '' : 'not ';
print "ok 12\n";


$conf->add(<<CONFIG) or die $@;
<this is>
    one thing
</this>
<this also>
    other thing
</this>
addTest worked
CONFIG

$q=$conf->get("addTest");
die Dumper $conf unless $q;
print $q eq 'worked' ? '' : 'not ';
print "ok 13\n";

$q=$conf->get("this");
die Dumper $conf unless $q;
die Dumper $q unless 'HASH' eq ref $q;
print 2==keys %$q ? '' : 'not ';
print "ok 14\n";

