# $Id: 20_factory.t,v 1.1.1.1 2001/07/06 00:03:05 fil Exp $
use strict;
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..9\n"; }
use JAAS::Factory;

my $loaded = 1;
END {print "not ok 1\n" unless $loaded;}
print "ok 1\n";

my $factory=JAAS::Factory->new([qw(Test::One Test::Two Test::Three)]);
my $OK=2;

my $q;
$q=$factory->make('Test::One');
($q and $$q == 1) or print "not ";
print "ok ", $OK++, "\n";

$q=$factory->make('Test::Two');
($q and $$q == 2) or print "not ";
print "ok ", $OK++, "\n";

$q=$factory->make('Test::Three');
($q and $$q == 3) or print "not ";
print "ok ", $OK++, "\n";


######################################
$factory=JAAS::Factory->new({
            One=>{class=>'Test::One'},
            Two=>{package=>'Test::Two'},
            Three=>{class=>'Test::Three'},
            Four=>{class=>'t::Four'},
            Five=>{class=>'Test::N', args=>[5]},
        });

######################################
# 5
$q=$factory->make('One');
die $@ if $@;
($q and $$q == 1) or print "not ";
print "ok ", $OK++, "\n";



######################################
# 6;
$q=$factory->make('Two');
($q and $$q == 2) or print "not ";
print "ok ", $OK++, "\n";

######################################
# 7
$q=$factory->make('Three');
($q and $$q == 3) or print "not ";
print "ok ", $OK++, "\n";

######################################
# 8, 9
$q=$factory->make('Four');
die $@ if $@;
($q and $$q == 4) or print "not ";
print "ok ", $OK++, "\n";


$q=$factory->make('Five');
die $@ if $@;
($q and $$q == 5) or print "not ";
print "ok ", $OK++, "\n";


##################################################################
package Test::One;
sub new { my $n=1; bless \$n, $_[0]}

##################################################################
package Test::Two;
sub new { my $n=2; bless \$n, $_[0]}

##################################################################
package Test::Three;
sub new { my $n=3; bless \$n, $_[0]}

package Test::N;
sub new { my $n=$_[1]; bless \$n, $_[0]}
