# $Id: 10_relations.t,v 1.1 2001/06/29 14:14:04 fil Exp $
use strict;
use Data::Dumper;

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..12\n"; }
use JAAS::Object::Relationships;

my $loaded = 1;
END {print "not ok 1\n" unless $loaded;}
print "ok 1\n";

my $notary=JAAS::Object::Relationships->new();

# excersize through the insane syntax
$notary->add_types([qw(subscribed)]);
$notary->add_types({watching=>[qw(store)]});
$notary->add_types({married=>{bidirectional=>1}});
print "ok 2\n";


$notary->nail('pete'  , 'subscribed', 'Montreal Gazette');
print "ok 3\n";
$notary->nail('betty' , 'subscribed', 'Montreal Gazette');
$notary->nail('george', 'subscribed', 'Montreal Gazette')
            ->nail('Journal de Montreal');  # syntatic sugar
print "ok 4\n";




my @sub=sort $notary->find('subscribed', 'Montreal Gazette');
print "ok 5\n";

(@sub==3 and $sub[0] eq 'betty' and $sub[1] eq 'george' and $sub[2] eq 'pete')
        or print 'not ';
print "ok 6\n";




@sub=sort $notary->rfind('subscribed', 'george');
print "ok 7\n";

(@sub==2 and $sub[0] eq 'Journal de Montreal' and $sub[1] eq 'Montreal Gazette')
        or print 'not ';
print "ok 8\n";



$notary->nail('pete', 'married', 'betty');  
@sub=$notary->find('married', 'betty');
(@sub==1 and $sub[0] eq 'pete')
        or print 'not ';
print "ok 9\n";



$notary->nail('george', 'watching', 'betty', {restraining_order=>'pending'});
# warn Dumper $notary;
my $stalker=$notary->find('watching', 'betty');
# warn Dumper $stalker;
(keys(%$stalker)==1 and $stalker->{george}{restraining_order} eq 'pending') 
        or print "not ";
print "ok 10\n";
    


$notary->remove('betty');
@sub=$notary->find('married', 'pete');
(@sub==0)
        or print 'not ';
print "ok 11\n";

# warn Dumper $notary;


$notary->break('pete', 'subscribed', 'Montreal Gazette');

# warn Dumper $notary;
@sub=$notary->find('subscribed', 'Montreal Gazette');
(@sub==1 and $sub[0] eq 'george')
        or print 'not ';
print "ok 12\n";
