# $Id: 20_services.t,v 1.7 2001/09/19 07:57:40 fil Exp $
use strict;
BEGIN { $Data::Dumper::Indent=1;}
use Data::Dumper;

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..16\n"; }

sub POE::Kernel::TRACE_REFCOUNT {0}
sub POE::Kernel::TRACE_EVENTS{0}

sub POE::Kernel::ASSERT_DEFAULT {1}

use JAAS::Object;
use JAAS::Object::Services;
use POE::Kernel;
use Carp;
JAAS::Object::Services->spawn();

my $loaded = 1;
END {print "not ok 1\n" unless $loaded;}
print "ok 1\n";

my $Q=2;

###################################################################
# Create objects and define their public methods

my $some_object=SomePackage->new({
    name=>'SomeObject', 
    methods=>{
        method3=>{respond=>1,    # means last arg is in fact postback
                  args_n=>1},    # Number of args
        method1=>{},
        method2=>{},
        postback=>{args_n=>1},
        reply=>{},
        arr_matey=>{},
        hop_along=>{},
        hop1=>{},
        hop2=>{xrespond=>1},     # useless use of respond, eh
        hop3=>{respond=>1},
        hop4=>{},
        hop5=>{},
        hop_back=>{},
    }
});
JAAS::Object->spawn(object=>$some_object);

my $other=OtherPackage->new({
    name=>'OtherObject', 
    methods=>{
        m1=>{args_n=>1},
        errors=>{},
        err=>{}
    }
});
JAAS::Object->spawn(object=>$other);
#$poe_kernel->post($id=>"_attach", $other);

my $third=SomePackage->new({
    name=>'ThirdObject', 
    methods=>{some=>{}, 
              array11=>{},
            }
});
JAAS::Object->spawn(object=>$third);

# start the ball rolling
# warn "***********************\n";
$poe_kernel->post(OtherObject=>'m1', 2);
# warn "Running...";
$poe_kernel->run();

ok(16);

################################################################
sub ok
{
    my($n, $ok)=@_;
    croak "$n is a reference" if ref $n;
    croak "$n is a bit excessive" if $n > 1000;
    my $not=(@_==1 or $ok) ? '' : "not ";
    if(defined $n) {
        if($n < $Q) {
            $not="not ";
        } elsif($n > $Q) {
            foreach my $i ($Q .. ($n-1)) {
                print "not ok $i\n";
            }
            $Q=$n;
        }
    }
    print "${not}ok $Q\n";
    $Q++;
}


################################################################
package OtherPackage;
use strict;
use JAAS::Object::Services;
use Data::Dumper;

use JAAS::Object::Delegate;
use vars qw(@ISA);
BEGIN { @ISA=qw(JAAS::Object::Delegate);}

sub new
{
    my($package, $args)=@_;
    die "no methods" unless $args->{methods};
    die "no name" unless $args->{name};
    my $self=$package->SUPER::new($args);
    return $self;
}

sub methods { return %{$_[0]->{methods}}}

sub m1
{
    my($self, $q)=@_;
    $jaas_relationships->nail($self, 'on_error', 'SomeObject',
                                    "errors\@$self->{name}");

#    $jaas_relationships->nail($self, 'on_error', 'SomeObject',
#                                    "err\@$self->{name}");
    $jaas_relationships->nail($self, 'on_warning', 'SomeObject',
                                    "err\@$self->{name}");

    $jaas_relationships->nail($self, 'on_error', 'OtherObject',
                                    "err\@$self->{name}");
    $jaas_relationships->nail($self, 'on_warning', 'OtherObject',
                                    "err\@$self->{name}");

    $jaas_relationships->nail($self, 'on_error', 'ThirdObject',
                                    "err\@$self->{name}");
    $jaas_relationships->nail($self, 'on_warning', 'ThirdObject',
                                    "err\@$self->{name}");

    die "To many times!\n" if $self->{m1}++;
    ::ok($q);
    $jaas_services->post('method1@SomeObject', $q+1);
}

sub errors
{
    my($self, $err)=@_;
    1 and print STDERR "Got an error :", Dumper $err;
    ::ok(15);       # LAST ONE
}

sub err
{
    my($self, $err)=@_;
    warn "HELLO";
    warn Dumper $err;
}

################################################################
package SomePackage;
use strict;
use JAAS::Object::Services;

use vars qw(@ISA);
BEGIN { @ISA=qw(OtherPackage);}

sub method1
{
    my($self, $q)=@_;
    die "To many times!\n" if $self->{m1}++;
    ::ok($q);   # 3
    $jaas_services->post("method2", $q+1);
}

sub method2
{
    my($self, $q)=@_;
    die "To many times!\n" if $self->{m2}++;
    ::ok($q);   # 4
    # method3 has respond set, so answer goes to "postback"    
    $jaas_services->post("method3", 42, "postback");

    
}

sub method3
{
    my($self, $n)=@_;
    die "To many times!\n" if $self->{m3}++;
    ::ok(5);
    return -$n;
}

sub postback
{
    my($self, $n)=@_;
    ::ok(6, ($n==-42));
    $jaas_services->post({to=>'some@ThirdObject', "reply-to"=>"reply"}, 7);
}



sub reply
{
    my($self, $q)=@_;
    die "NO VALUE" unless defined $q;
    
#    print STDERR  "======================== bar $q\n";
    ::ok($q++);     # 8
#    print STDERR  "bar\n";
    $jaas_services->post({  to=>'array11@ThirdObject', 
                            'reply-to'=>'arr_matey',
                            'wantarray'=>1
                        }, $q);
}

sub some
{
    my($self, $q)=@_;
    ::ok($q++);     # 7
    return $q;
}

sub array11
{   
    my($self, $q)=@_;
    return [$q, $q+1];
}

sub arr_matey
{
    my($self, $q, $w)=@_;
    die "$q is a reference" if ref $q;

    ::ok(9, $q==9);                 # 9
    ::ok(10, $w==10);               # 10
    # print "q=$q\n";
    $jaas_services->continuation('hop_along', $w+1);
}

sub hop_along
{
    my($self, $q)=@_;
    $jaas_services->post({to=>'hop1', OOB=>1, 
                          'reply-to'=>'hop_back'}, $q+1);
    # print "q=$q\n";
    ::ok(11, $q==11);
}

sub hop_back
{
    my($self, $q)=@_;
    warn "==== $q\n";
    ::ok(14, $q==17);
    $jaas_services->post("method2", 14);
                                # will cause an error, and is the last step
}

sub hop1
{
    my($self)=@_;
    ::ok(12);
    $jaas_services->continuation('hop2');
}

sub hop2
{
    my($self)=@_;

    ::ok(13);
    $jaas_services->post('hop3', 34,
                    $jaas_services->build_continuation('hop4'));
}


sub hop3
{
    my($self, $q)=@_;
    die "$q isn't 34" unless $q==34;
    return $q/2;
}

sub hop4
{
    my($self, $q)=@_;
    return $q;
}

