# $Id: 30_exceptions.t,v 1.2 2001/08/03 20:38:38 fil Exp $
use strict;
use Data::Dumper;

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..6\n"; }

# sub POE::Kernel::TRACE_REFCOUNT {1}
# sub POE::Kernel::TRACE_EVENTS{1}

use JAAS::Object;
use JAAS::Object::Services;
use POE::Kernel;

JAAS::Object::Services->spawn();

my $loaded = 1;
END {print "not ok 1\n" unless $loaded;}
print "ok 1\n";

my $Q=2;


sub DEBUG () { 0 };

###################################################################
# Create objects and define their public methods
my $some_object=OtherPackage->new({
    name=>'SomeObject', 
    methods=>{
        bad_args=>{args_n=>1},  
        do_error=>{},
        do_warn=>{},
    }
});
JAAS::Object->spawn(object=>$some_object);


# Monitor _start starts the ball rolling
MyMonitor->spawn();
DEBUG and warn "***********************\n";
DEBUG and warn "Running...";
$poe_kernel->run();

ok(6);

################################################################
sub ok
{
    my($n, $ok)=@_;
    my $not=(@_==1 or $ok) ? '' : "not ";
    if(defined $n) {
        if($n < $Q) {
            $not="not ";
        } elsif($n > $Q) {
            foreach my $i ($Q .. ($n-1)) {
                print "not ok $i\n";
            }
            $Q=$n;
        }
    }
    print "${not}ok $Q\n";
    $Q++;
}


################################################################
package OtherPackage;
use strict;
use JAAS::Object::Services;
use Data::Dumper;

use JAAS::Object::Delegate;
use vars qw(@ISA);
BEGIN { @ISA=qw(JAAS::Object::Delegate);}

sub new
{
    my $self=shift(@_)->SUPER::new(@_);
    die "no methods" unless $self->{methods};
    die "no name" unless $self->{name};
    return $self;
}

sub methods { return %{$_[0]->{methods}}}

sub bad_args
{
    my($self, $q)=@_;
    warn $q;
}

sub do_error
{
    my($self, $err)=@_;
    die "YOW!";
}

sub do_warn
{
    my($self, $err)=@_;
    warn "YOW!";
}



################################################################
package MyMonitor;
use strict;
use POE::Session;
use JAAS::Object::Services qw($jaas_relationships);

BEGIN
{
    *DEBUG=\&main::DEBUG;
    *ok=\&main::ok;
}

sub spawn 
{
    my($package)=@_;
    POE::Session->create(
        package_states=>[$package=>[qw(_start error warn next)]],
        heap=>[qw(bad_args do_error not_there)],
    );
}

sub _start
{
    $_[KERNEL]->alias_set(__PACKAGE__);
    $jaas_relationships->nail($_[SESSION]->ID, 'on_error', 'SomeObject', 
                            {   to=>{object=>$_[SESSION]->ID,
                                     method=>'error'}});

    $jaas_relationships->nail($_[SESSION]->ID, 'on_warning', 'SomeObject', 
                            {   to=>{object=>$_[SESSION]->ID,
                                     method=>'warn'}});
    $_[KERNEL]->yield('next');
}

sub error
{
    DEBUG and CORE::warn "Error: $_[ARG0]";
    $_[KERNEL]->yield('next');
}
sub warn
{
    DEBUG and CORE::warn "Warning: $_[ARG0]";
    $_[KERNEL]->yield('next');
}
sub next
{
    ok( 5-@{$_[HEAP]} );
    my $method=shift @{$_[HEAP]};
    return unless $method;

    DEBUG and CORE::warn "Posting to $method\n";
    $_[KERNEL]->post(SomeObject=>$method);
}
