#!/usr/bin/perl -w
use lib qw(/home/fil/prive/perl5lib/lib/site_perl);
use strict;
use POE;
use POE::Component::IKC::Responder;


POE::Component::IKC::Responder->spawn;
Client->spawn("Client$$");

warn "Client$$...\n";
$poe_kernel->run;

##############################################################
package Client;
use strict;
use POE::Session;
use POE::Component::IKC::Client;
use pack::Increment;

my $ID;
BEGIN {
    $ID='some-context-name';
}

sub spawn
{
    my($package, $name)=@_;
    POE::Component::IKC::Client->spawn(
            port=>31337, name=>$name, subscribe=>[qw(poe://Context/main)]);

    POE::Session->create(
        args=>[$name],
        package_states=>[
            $package =>[qw(_start display subscribed fetch)]
        ]
    );
}

sub _start
{
    my($kernel, $heap, $name)=@_[KERNEL, HEAP, ARG0];
    $heap->{name}=$name;
    $kernel->alias_set($name);
    $kernel->post(IKC=>'publish', $name=>[qw(display)]);
    $kernel->post(IKC=>'monitor', 'Context'=>{
            subscribe=>'subscribed'
        });
}

sub _stop
{
    warn "What you say?";
}

sub subscribed
{
    my($kernel, $heap)=@_[KERNEL, HEAP];
    $kernel->post('poe://Context/main'=>'create', $ID);
    $kernel->yield('fetch');
}
sub fetch
{
    my($kernel, $heap)=@_[KERNEL, HEAP];

    $kernel->post(IKC=>'call', 'poe://Context/main/get', 
                {id=>$ID, name=>$heap->{name}, obj=>'Increment'},
                  "poe:/$heap->{name}/display");
}

sub display
{
    my($kernel, $heap, $obj)=@_[KERNEL, HEAP, ARG0];
    if(ref $obj) {
        my $n=$obj->incr;
        print "$n\n";
        $kernel->post('poe://Context/main' => 'putback',
                {id=>$ID, name=>$heap->{name}, obj=>'Increment', in=>$obj});

        
        $kernel->post('poe://Context/main'=>'delete', $ID) if $n == 10;
        $kernel->yield('fetch');
    } 
    elsif($obj==-1) {
        print "Yow! Deleted properly\n";
        $kernel->post(IKC=>'shutdown');
    }
    elsif($obj) {
        warn "Error! $obj";
    } else {
        warn "$$: LOCKED\n";
        $kernel->delay('fetch', 2);
    }
}
