#!/usr/bin/perl -w

use lib qw(/home/fil/prive/perl5lib/lib/site_perl);

#################################################
# Kill Test 
# ----------
# Tests the 'kill' handler on Context.
# Creates a working session on Context then kills it outright
# It then shows the content of the objects to prove
# it got them.
#################################################

use strict;
use POE;
use POE::Component::IKC::Client;
use POE::Component::IKC::Responder;
use POE::Filter::Reference;

use pack::English;
use pack::Russki;
use pack::Increment;

my $ID = "TestRun";
my $NAME = "Client$$";
my $STORE = POE::Filter::Reference->new();

create_ikc_client (port=>31337, name=>$NAME, subscribe=>[qw(poe://Context/main)]);

POE::Session->new (
	_start=>\&cl_start,
	_stop=>\&cl_stop,
	killtest=>\&cl_killtest,
	display=>\&cl_display,
	register=>\&cl_register,
);

print "Running Client...\n";
$poe_kernel->run();
print "Exiting Client...\n";

#########################################################
sub cl_start {
	my ($kernel, $heap)=@_[KERNEL, HEAP];
	$kernel->alias_set('me');
	create_ikc_responder();
	$kernel->post('IKC', 'publish', 'me', [qw(display)]); # Needed for 'kill' handler
	$kernel->post('IKC', 'monitor', 'poe://Context/main', {register=>'register'});
}

#########################################################
sub cl_stop {
	print "_stop reached\n";
}

############################################################
sub cl_register {
	my ($kernel, $name)=@_[KERNEL, ARG1];
	print "- Connected to $name\n";
	$kernel->call('IKC', 'post', 'poe://Context/main/create', $ID);
	$kernel->yield('killtest');
}

############################################################
sub cl_killtest {
	my ($kernel, $heap)=@_[KERNEL, HEAP];
	print "Killing Session...\n";
	my $postback = "poe://$NAME/me/display";
	$kernel->call('IKC', 'post', 'poe://Context/main/kill', 
		{id=>$ID, postback=>$postback}); 
}

############################################################
sub cl_display {
	my ($kernel, $heap, $out)=@_[KERNEL, HEAP, ARG0];
	print $out;
#	my $ref = $STORE->get($out);
# 	my $objlist = $ref->[0];
#	my $en = ($objlist->{English})->new();
#	my $ru = ($objlist->{Russki})->new();
#	my $incr = ($objlist->{Increment})->new();

#	print "English message: ", $en->out(), "\n";
#	print "Russki message: ", $ru->out(), "\n";
#	print "Increment message: ", $incr->incr(), "\n";
}

				
			