#!/usr/bin/perl -w

use lib qw(/home/fil/prive/perl5lib/lib/site_perl);

##########################################################
# List test 1
# -----------
# Tests the three list methods of Context.
# 1) a list of session IDs
# 2) a list of locks (only)
# 3) a list of objects, locked or not 
#
# Be sure to run client-test.pl and/or client-test2.pl simultaneously so some clients
# are actually using objects on Context, otherwise the lists will be empty
############################################################

use strict;
use POE;
use POE::Component::IKC::Client;
use POE::Component::IKC::Responder;
use POE::Filter::Reference;

my $NAME = "Client$$";

create_ikc_client (port=>31337, name=>$NAME, subscribe=>[qw(poe://*/main)]);

POE::Session->new (
	_start=>\&cl_start,
	_stop=>\&cl_stop,
	register=>\&cl_register,
	list=>\&cl_list,
	locklist=>\&cl_locklist,
	blocklist=>\&cl_blocklist,
	locklist2=>\&cl_locklist2,
    [@ARGV]
);

# print "Running Client...\n";
$poe_kernel->run();
# print "Exiting Client...\n";

#########################################################
sub cl_start {
	my ($kernel, $heap, $id)=@_[KERNEL, HEAP, ARG0];
	$kernel->alias_set('me');
	create_ikc_responder();
	$kernel->post('IKC', 'monitor', 'poe://Context/main', 
                {register=>'register', data=>$id});
}

#########################################################
sub cl_stop {
#	print "_stop reached\n";
}

############################################################
sub cl_register {
	my ($kernel, $heap, $name, $id)=@_[KERNEL, HEAP, ARG1, ARG3];
	print "- Connected to $name\n";
    if($id) {
        $heap->{ID}=$id;
        $kernel->yield('locklist2', $id);
        $kernel->yield('blocklist', $id);
    } else {
        $kernel->yield('list');
    }
}

############################################################
sub cl_list {
	my ($kernel, $list)=@_[KERNEL, ARG0];
	if ($list) {
		print "Context List:\n";
		foreach my $session (@$list) {
			print "   $session\n";
		}
        print "    (Empty)\n" unless @$list;
        $kernel->post(IKC=>'shutdown');

	}
	else {
		$kernel->call('IKC', 'call', 'poe://Context/main/list',
	                '', 'poe:/me/list');
	}
}

##############################################################
sub cl_locklist2 {
	my ($kernel, $heap, $list)=@_[KERNEL, HEAP, ARG0];
	
	if (ref $list) {
		if ($list->{_err}) {
			print "Locklist: $heap->{ID} doesn't exist\n";
		}
		else {
			print "Object list for $heap->{ID}:\n";
			foreach my $obj (keys %$list) {
				next if $obj eq '_err';
				my $owner = $list->{$obj} ? "($list->{$obj})" : '';
				print "   $obj $owner\n";
			}
            print "    (Empty)\n" unless %$list;
		}
	}
	else {
        $kernel->call('IKC', 'call', 'poe://Context/main/locklist',
                        {id=>$list, type=>1, }, 'poe:/me/locklist2');
 	}
}


##############################################################
sub cl_blocklist {
	my ($kernel, $heap, $list)=@_[KERNEL, HEAP, ARG0];
	
	if (ref $list) {
        print "Block list for $heap->{ID}:\n";
        foreach my $id (sort keys %$list) {
            print "    $id is blocked by $list->{$id}\n";
        }
        print "    (Empty)\n" unless %$list;

        $kernel->post(IKC=>'shutdown');
    } else {
        $kernel->call('IKC', 'call', 'poe://Context/main/blocklist',
                        {id=>$list, type=>1}, 'poe:/me/blocklist');
    } 
}
