#!/usr/bin/perl -w

use lib qw(/home/fil/prive/perl5lib/lib/site_perl);

#################################################
# Block Test 
# ----------
# Tests the 'block' handler on Context
# 1) requests object English
# 2) posts the 'block' -- Context should block all obj but English
# 3) sleep a while..., releases English -- now Context should block all, tell that the session
#	is fully blocked
# 4) sleep..., posts an 'unblock'
#
# You can also run list-test.pl to check out the blocking list
#################################################

use strict;
use POE;
use POE::Component::IKC::Client;
use POE::Component::IKC::Responder;
use POE::Filter::Reference;

use pack::English;
use pack::Russki;

my $ID = "TestRun";
my $NAME = "Client$$";
my $NAME2 = "OtherClient$$";

create_ikc_client(port=>31337, name=>$NAME, 
                    subscribe=>[qw(poe://Context/main)], 
                    aliases=>[$NAME2]);

POE::Session->new (
	_start=>\&cl_start,
	_stop=>\&cl_stop,
	loop=>\&dumb_loop,
	display=>\&cl_display,
	register=>\&cl_register,
    release=>\&cl_release,
    unblock=>\&cl_unblock,
);

print "Running Client...\n";
$poe_kernel->run();
print "Exiting Client...\n";

#########################################################
sub cl_start {
	my ($kernel, $heap)=@_[KERNEL, HEAP];
	$kernel->alias_set('me');
	create_ikc_responder();
	$kernel->post('IKC', 'monitor', 'poe://Context/main', {register=>'register'});
}

#########################################################
sub cl_stop {
	print "_stop reached\n";
}

#########################################################
sub dumb_loop {
	my ($kernel)=$_[KERNEL];
	$kernel->call('IKC', 'call', 'poe://Context/main/get', 
		{id=>$ID, obj=>'English', name=>$NAME2}, 'poe:/me/display');
#	$kernel->call('IKC', 'call', 'poe://Context/main/get',
#                {id=>$ID, obj=>'Russki', name=>$NAME}, 'poe:/me/display');	
	sleep(1);
}

##########################################################
sub cl_display {
	my ($kernel, $heap, $obj)=@_[KERNEL, HEAP, ARG0];
	
	if ($obj == 1) {
		print "Object doesn't exist!\n";
		$kernel->yield('loop');
	}
	elsif ($obj) {
		my $msg = $obj->out();
		print "**Message is: $msg\n";
		print "Blocking...\n";
		$kernel->call('IKC', 'post', 'poe://Context/main/block', 
                            {id=>$ID, name=>$NAME});
        $kernel->delay('release', 10);
	}
	else {
		print "Locked!!\n";
		sleep(1);
		$kernel->yield('loop');
	}
}
sub cl_release
{
    my($kernel, $heap)=@_[KERNEL, HEAP];

    print "Releasing English...\n";
    $kernel->call('IKC', 'post', 'poe://Context/main/release',
			{id=>$ID, obj=>'English', name=>$NAME2});
    $kernel->delay('unblock', 3);
}
sub cl_unblock
{
    my($kernel, $heap)=@_[KERNEL, HEAP];

    print "Unblocking...\n";
	$kernel->post('IKC', 'post', 'poe://Context/main/unblock', 
                            {id=>$ID, name=>$NAME});
	print "Done!!\n";
    $kernel->post(IKC=>'shutdown');
}

############################################################
sub cl_register {
	my ($kernel, $name)=@_[KERNEL, ARG1];
	print "- Connected to $name\n";
	$kernel->call('IKC', 'post', 'poe://Context/main/create', $ID);
	$kernel->yield('loop');
}
