#!/usr/bin/perl -w

use lib qw(/home/fil/prive/perl5lib/lib/site_perl);

#################################################
# Client Test 1
# -------------
# Requests two objects and outputs their message,
# then tries endlessly to request them again, with no success
# as they become locked (i.e. the client hasn't relinquished them back). 
# Notice, when you terminate the client, that the server
# releases the lock on both objects.
#################################################

use strict;
use POE;
use POE::Component::IKC::Client;
use POE::Component::IKC::Responder;

use pack::English;
use pack::Russki;

my $ID = "TestRun";
my $NAME = "Client$$";

create_ikc_client (port=>31337, name=>$NAME, subscribe=>[qw(poe://Context/main)]);

POE::Session->new (
	_start=>\&cl_start,
	_stop=>\&cl_stop,
	loop=>\&dumb_loop,
	display=>\&cl_display,
	register=>\&cl_register,
);

print "Running Client...\n";
$poe_kernel->run();
print "Exiting Client...\n";

#########################################################
sub cl_start {
	my ($kernel, $heap)=@_[KERNEL, HEAP];
	$kernel->alias_set('me');
	create_ikc_responder();
	$kernel->post('IKC', 'monitor', 'poe://Context/main', {register=>'register'});
}

#########################################################
sub cl_stop {
	print "_stop reached\n";
}

#########################################################
sub dumb_loop {
	print "##Loop reached\n";
	my ($kernel)=$_[KERNEL];
	$kernel->call('IKC', 'call', 'poe://Context/main/get', 
		{id=>$ID, obj=>'English', name=>$NAME}, 'poe:/me/display');
	$kernel->call('IKC', 'call', 'poe://Context/main/get',
                {id=>$ID, obj=>'Russki', name=>$NAME}, 'poe:/me/display');	
	sleep(1);
}

##########################################################
sub cl_display {
	my ($kernel, $heap, $obj)=@_[KERNEL, HEAP, ARG0];
	
	if ($obj == 1) {
		print "Object doesn't exist!\n";
		$kernel->yield('loop');
	}
	elsif ($obj) {
		my $msg = $obj->out();
		print "**Message is: $msg\n";
		$kernel->yield('loop');
	}
	else {
		print "Locked!!\n";
		sleep(1);
		$kernel->yield('loop');
	}
}

############################################################
sub cl_register {
	my ($kernel, $name)=@_[KERNEL, ARG1];
	print "- Connected to $name\n";
	$kernel->call('IKC', 'post', 'poe://Context/main/create', $ID);
	$kernel->yield('loop');
}
