#!/usr/bin/perl -w

use lib qw(/home/fil/prive/perl5lib/lib/site_perl);

###################################################
# Client Test 2
# -------------
# This client requests an object, calls the incr() method on
# its lone data (a number), outputs it and gives back the object
# to the server. This is run as an endless loop.
# If you kill the object then start it again, the object's data
# will be the same, as the Context server preserves it.
###################################################

use strict;
use POE;
use POE::Component::IKC::Client;
use POE::Component::IKC::Responder;

use pack::Increment;

my $ID = "TestRun";
my $NAME = "Client$$";

create_ikc_client (port=>31337, name=>$NAME, subscribe=>[qw(poe://*/main)]);

POE::Session->new (
	_start=>\&cl_start,
	_stop=>\&cl_stop,
	loop=>\&dumb_loop,
	display=>\&cl_display,
	register=>\&cl_register,
);

print "$$: Running Client...\n";
$poe_kernel->run();
print "$$: Exiting Client...\n";

#########################################################
sub cl_start {
	my ($kernel, $heap)=@_[KERNEL, HEAP];
	$kernel->alias_set('me');
	create_ikc_responder();
	$kernel->post('IKC', 'monitor', 'poe://Context/main', {register=>'register'});
}

#########################################################
sub cl_stop {
	print "$$: _stop reached\n";
}

#########################################################
sub dumb_loop {
	print "$$: ##Loop reached\n";
	my ($kernel)=$_[KERNEL];
	$kernel->call('IKC', 'call', 'poe://Context/main/get', 
		{id=>$ID, obj=>'Increment', name=>$NAME}, 'poe:/me/display');
}

##########################################################
sub cl_display {
	my ($kernel, $heap, $obj)=@_[KERNEL, HEAP, ARG0];
	
	if ($obj) {
		my $msg = $obj->incr();
		print "$$: ** Number is: $msg\n";
		$kernel->post(IKC=>'post', 'poe://Context/main/putback',
			{id=>$ID, obj=>'Increment', name=>$NAME, in=>$obj});
		$kernel->delay('loop', 1);
	}
	else {
		print "$$: Locked!!\n";
		$kernel->delay('loop', 1);
	}
}

############################################################
sub cl_register {
	my ($kernel, $name)=@_[KERNEL, ARG1];
	print "$$: -- Connected to $name\n";
	$kernel->call('IKC', 'post', 'poe://Context/main/create', $ID);
	$kernel->yield('loop');
}
