#!/usr/bin/perl -w

use lib qw(/home/fil/prive/perl5lib/lib/site_perl);

##########################################################
# List test 1
# -----------
# Tests the three list methods of Context.
# 1) a list of session IDs
# 2) a list of locks (only)
# 3) a list of objects, locked or not 
#
# Be sure to run client-test.pl and/or client-test2.pl simultaneously so some clients
# are actually using objects on Context, otherwise the lists will be empty
############################################################

use strict;
use POE;
use POE::Component::IKC::Client;
use POE::Component::IKC::Responder;
use POE::Filter::Reference;

my $ID = "TestRun";
my $NAME = "Client$$";

create_ikc_client (port=>31337, name=>$NAME, subscribe=>[qw(poe://*/main)]);

POE::Session->new (
	_start=>\&cl_start,
	_stop=>\&cl_stop,
	register=>\&cl_register,
	list=>\&cl_list,
	locklist=>\&cl_locklist,
	blocklist=>\&cl_blocklist,
	locklist2=>\&cl_locklist2
);

print "Running Client...\n";
$poe_kernel->run();
print "Exiting Client...\n";

#########################################################
sub cl_start {
	my ($kernel, $heap)=@_[KERNEL, HEAP];
	$kernel->alias_set('me');
	create_ikc_responder();
	$kernel->post('IKC', 'monitor', 'poe://Context/main', {register=>'register'});
}

#########################################################
sub cl_stop {
	print "_stop reached\n";
}

############################################################
sub cl_register {
	my ($kernel, $name)=@_[KERNEL, ARG1];
	print "- Connected to $name\n";
	$kernel->call('IKC', 'post', 'poe://Context/main/create', $ID);
	$kernel->yield('list');
}

############################################################
sub cl_list {
	my ($kernel, $list)=@_[KERNEL, ARG0];
	if ($list) {
		print "Context List:\n";
		foreach my $session (@$list) {
			print "- $session active\n";
		}
		$kernel->yield('locklist');
	}
	else {
		$kernel->call('IKC', 'call', 'poe://Context/main/list',
	                '', 'poe:/me/list');
	}
}

###############################################################
sub cl_locklist {
	my ($kernel, $list)=@_[KERNEL, ARG0];
	
	if ($list) {
		if ($list->{_err}) {
			print "Locklist: ID doesn't exist\n";
		}
		else {
			print "Lock List:\n";
			foreach my $obj (keys %$list) {
				next if $obj eq '_err';
				print "   $list->{$obj} has lock on $ID/$obj\n";
			}
			$kernel->yield('locklist2');
		}
	}
	else {
               $kernel->call('IKC', 'call', 'poe://Context/main/locklist',
                        {id=>$ID}, 'poe:/me/locklist');
 	}
}

##############################################################
sub cl_locklist2 {
	my ($kernel, $list)=@_[KERNEL, ARG0];
	
	if ($list) {
		if ($list->{_err}) {
			print "Locklist: ID doesn't exist\n";
		}
		else {
			print "Object List:\n";
			foreach my $obj (keys %$list) {
				next if $obj eq '_err';
				my $owner = $list->{$obj} ? "($list->{$obj})" : '';
				print "   $ID/$obj $owner\n";
			}
		}
        $kernel->yield('blocklist');
	}
	else {
        $kernel->call('IKC', 'call', 'poe://Context/main/locklist',
                        {id=>$ID, type=>1}, 'poe:/me/locklist2');
 	}
}


##############################################################
sub cl_blocklist {
	my ($kernel, $list)=@_[KERNEL, ARG0];
	
	if ($list) {
        print "Block list:\n";
        foreach my $id (sort keys %$list) {
            print "    $id is blocked by $list->{$id}\n";
        }

        $kernel->post(IKC=>'shutdown');
    } else {
        $kernel->call('IKC', 'call', 'poe://Context/main/blocklist',
                        {id=>$ID, type=>1}, 'poe:/me/blocklist');
    } 
}
