#!/usr/bin/perl -w

use lib qw(/home/fil/prive/perl5lib/lib/site_perl);

#################################################
# Client Test 1
# -------------
# Requests two objects and outputs their message,
# then tries endlessly to request them again, with no success
# as they become locked (i.e. the client hasn't relinquished them back). 
# Notice, when you terminate the client, that the server
# releases the lock on both objects.
#################################################

use strict;
sub POE::Kernel::ASSERT_RETURNS  () { 1 }

use POE;
use POE::Component::IKC::Client;
use POE::Component::IKC::Responder;

use pack::English;
use pack::Russki;

my $ID = "TestRun";
my $NAME = "Client$$";

create_ikc_client (port=>31337, name=>$NAME);

POE::Session->new (
	_start=>\&cl_start,
	_stop=>\&cl_stop,
	loop=>\&dumb_loop,
	display=>\&cl_display,
	register=>\&cl_register,
);

print "$$: Running Client...\n";
$poe_kernel->run();
print "$$: Exiting Client...\n";

#########################################################
sub cl_start {
	my ($kernel, $heap)=@_[KERNEL, HEAP];
	$kernel->alias_set('me');
	create_ikc_responder();
#       $kernel->post(IKC=>'publish', 'me'=>[qw(display)]);
	$kernel->post('IKC', 'monitor', 'poe://Context/main', {register=>'register'});
}

#########################################################
sub cl_stop {
	print "_stop reached\n";
}

#########################################################
sub dumb_loop {
	print "$$: Loop reached\n";
	my ($kernel)=$_[KERNEL];
	$kernel->call('IKC', 'call', 'poe://Context/main/get', 
		{id=>$ID, obj=>'English', name=>$NAME}, 'poe:/me/display');

	$kernel->call('IKC', 'call', 'poe://Context/main/get',
                {id=>$ID, obj=>'Russki', name=>$NAME}, 'poe:/me/display');	
}

##########################################################
sub cl_display {
	my ($kernel, $heap, $sender, $obj)=@_[KERNEL, HEAP, SENDER, ARG0];
	
	if ($obj == -1) {
		print "$$: Object doesn't exist!\n";
        $kernel->post(IKC=>'shutdown');
	}
	elsif ($obj) {
		my $msg = $obj->out();
		print "$$: **Message is: $msg\n";
    	$kernel->post($sender => 'release', 
                        {id=>$ID, obj=>ref($obj), name=>$NAME});	
		$kernel->delay('loop', 1);
	}
	else {
		print "$$: Locked!!\n";
		$kernel->delay('loop', 2);
	}
}

############################################################
sub cl_register {
	my ($kernel, $name)=@_[KERNEL, ARG1];
	print "$$: - Connected to $name\n";
	$kernel->post(IKC=>'post',
                  'poe://Context/main/setup'=>{id=>$ID, name=>$NAME});
	$kernel->yield('loop');
}
