#!/usr/bin/perl -w
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..1\n"; }
END {print "not ok 1\n" unless $loaded;}
use JAAS::Object::Lifetime;
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

sub DEBUG {0};
use Data::Dumper;
use strict;

my $Q=2;

my %testdata=(
scalar=>[ 'hello'],
scalars=>[qw(hello world)],
hash=>[{hello=>'world', biff=>{bibble=>'borz'}, zittle=>[qw(miff moff)]}],
time=>[time],
);

foreach my $os (values %testdata) {
    foreach my $d (@$os) {
        $d=\(''.$d) unless ref $d;
        $d=new Nothing $d;
    }
}
# die Dumper \%testdata;

############################################################
my $life=new JAAS::Object::Lifetime (
        'profil'=>{type=>'profil',
                 tie=>'TestStore', expire=>10},
        'session'=>{type=>'session', 
                 tie=>'TestStore', expire=>2},
        'paranoid'=>{type=>'paranoid', 
                 tie=>'TestStore', expire=>2},
        );
END { ok(34) }
die "No life!" unless $life;
$life->key("1234567890abcdef");

$TestStore::mode='save';
DEBUG and warn "# Saving data";
foreach my $when (qw(profil session paranoid)) {
    $TestStore::type=$when;
    $life->save(\%testdata, $when);
    ok();
}

# die Dumper $TestStore::storage;

$TestStore::mode='restore';
DEBUG and warn "# Restoring data";
foreach my $when (qw(profil session paranoid)) {
    $TestStore::type=$when;
    ok(undef(), $life->restore(\%testdata, $when));
}

warn "# Sleeping 3 seconds...\n";
sleep 3;
$TestStore::mode='expire';
DEBUG and warn "# Expiring data";
$life->expire;

$TestStore::mode='restore';
DEBUG and warn "# Checking expiration";
foreach my $when (qw(profil session paranoid)) {
    $TestStore::type=$when;
    my $n=$life->restore(\%testdata, $when);
    ok(undef(), ($n xor $Nothing::expired));
    $Nothing::expired=1;
}
    


################################################################
sub ok
{
    my($n, $ok)=@_;
    my $not=(not defined($ok) or $ok) ? '' : "not ";

    if(defined $n) {
        $ok||=0;
        DEBUG and warn "# $Q ($n) == $not ($ok)\n";
        if($n < $Q) {
            $not="not ";
        } elsif($n > $Q) {
            foreach my $i ($Q .. ($n-1)) {
                print "not ok $i\n";
            }
            $Q=$n;
        }
    } elsif(DEBUG) {
        $ok=1;
        warn "# $Q == $not ($ok)";
    }
    print "${not}ok $Q\n";
    $Q++;
}


################################################################
package Nothing;
use strict;
use Data::Dumper;

sub DEBUG {::DEBUG()}
BEGIN {
    $Nothing::expired=0;
    *ok=\&::ok;
};

sub new
{
    my($package, $data)=@_;
    return bless {data=>$data}, $package;
}

sub lifetime_save
{
    my($self, $when)=@_;
    return $self->{data};
}

sub lifetime_restore
{
    my($self, $when, $saved)=@_;
    DEBUG and warn "# lifetime_restore";
    die "SHOULD NEVER HAPPEN! $when ", Dumper $saved if $Nothing::expired;
    ok(undef(), data_eq($self->{data}, $saved))
}

sub data_eq
{
    my($in, $out)=@_;
    my $r=ref $in;
#    return 0 unless $r eq ref $out;
    unless($r) {
        return $in eq $out;
    } 
    elsif($r eq 'SCALAR') {
        return $$in eq $$out;
    } 
    elsif($r eq 'ARRAY') {
        foreach my $q (0..$#$in) {
            return 0 unless data_eq($in->[$q], $out->[$q]);
        }
    } 
    elsif($r eq 'HASH') {
        foreach my $k (keys(%$in), keys(%$out)) {
            return 0 unless exists $in->{$k} and exists $out->{$k};
            return 0 unless data_eq($in->{$k}, $out->{$k});
        }
    } elsif($r ne ref $out) {           # objects
        return 0;
    }

    return 1;
}


################################################################
package TestStore;
use strict;

use Data::Dumper;
use vars qw($mode $VAR1 $type $storage);
BEGIN {
    $mode='error';
    *ok=\&::ok;
}
sub DEBUG {::DEBUG()}

sub TIEHASH
{
    my($package, $args)=@_;
    $storage->{$args->{type}}||=bless {type=>$args->{type}}, $package;
}

sub FETCH
{
    my($self, $key)=@_; 
    DEBUG and warn "# restore eq $mode, $self->{type} eq $type\n";

    ok(undef(), ($mode eq 'restore' and $type eq $self->{type}))
        unless $mode ne 'expire';
    die Dumper $self unless $self->{$key};
    local $VAR1;
    eval $self->{$key};
    return $VAR1;
}

sub STORE
{
    my($self, $key, $data)=@_;
    DEBUG and warn "# save eq $mode, $self->{type} eq $type\n";
    ok(undef(), ($mode eq 'save' and $type eq $self->{type}));
    $self->{$key}=Dumper $data;
    $self->{TIME}{$key}=time;
}

sub EXISTS
{
    my($self, $key)=@_;
    return exists $self->{$key};
}

sub DELETE
{
    my($self, $key)=@_;
    delete $self->{$key};
    delete $self->{TIME}{$key};
}

sub expire
{
    my($self, $time)=@_;
    my $cutoff=time - $time;
    my @delete;
    while(my($key, $set)=each %{$self->{TIME}}) {
        next if $set > $cutoff;
        push @delete, $key;
    }
    delete @{$self->{TIME}}{@delete};
    delete @{$self}{@delete};
    # warn Dumper $self;
}

1;