package POE::Component::IKC::Proxy;

##############################################################################
# $Id$
# Copyright 1999 Philip Gwyn.  All rights reserved.
# This program is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# Contributed portions of IKC may be copyright by their respective
# contributors.  

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK $ikc_kernel);
use Carp;
use Data::Dumper;

use POE qw(Session);
use POE::Component::IKC::Specifier;

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(create_ikc_proxy);
$VERSION = '0.02';

sub DEBUG { 1 }

sub create_ikc_proxy
{
    my($r_kernel, $r_session)=@_;
    my $name=specifier_name({kernel=>$r_kernel, session=>$r_session});
    POE::Session->new(__PACKAGE__, [qw(_start _stop _delete _default)], 
                                    [$name, $r_kernel, $r_session]);
}

sub _start
{
    my($kernel, $heap, $name, $r_kernel, $r_session)=
                    @_[KERNEL, HEAP, ARG0, ARG1, ARG2];
    
    $heap->{name}=$name;
    $heap->{callback}={kernel=>$r_kernel, session=>$r_session, 
                       state=>'IKC:proxy'};
    DEBUG && print "Proxy for $name created\n";
    $kernel->alias_set($name);
}

sub _delete
{
    my($kernel, $heap)=@_[KERNEL, HEAP];
    $kernel->alias_remove($heap->{name});    
}

sub _stop
{
    DEBUG && print "Proxy for $_[HEAP]->{name} deleted\n";
}


sub _default
{
    my($kernel, $heap, $state, $args)=@_[KERNEL, HEAP, ARG0, ARG1];
    return if $state =~ /^_/;
    warn "Attempt to respond to a callback with $state\n"
        if not $heap->{callback};
    warn "Proxy $heap->{name}/$state posted\n";

    $kernel->call('IKC', 'post', $heap->{callback}, [$state, $args]);
}

1;
