package POE::Component::IKC::Specifier;

############################################################
# $Id$
#
# Copyright 1999 Philip Gwyn.  All rights reserved.
# This program is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# Contributed portions of IKC may be copyright by their respective
# contributors.  

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
use Carp;
use POE;

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw( specifier_parse specifier_name );
$VERSION = '0.02';

sub DEBUG { 1 }

#----------------------------------------------------
# Turn an specifier into a hash ref
sub specifier_parse ($)
{
    my($specifier)=@_;
    return if not $specifier;
    unless(ref $specifier)
    {
        if($specifier=~m(^poe:
                        (?:
                            (//)
                            (\*|[- \w]+|[a-zA-Z0-9][-.a-zA-Z0-9]+:\d+)?
                        )?
                        (?:
                            (/)
                            ([- \w]+)        
                        )?
                        (?: 
                            (/)?
                            ([- \w]*)
                        )?
                        $)x)
        {
            $specifier={kernel=>$2, session=>$4, state=>$6};
        } else
        {
            return;
        }
    } 
    $specifier->{kernel}||='';
    $specifier->{session}||='';
    $specifier->{state}||='';
    return $specifier;
}

#----------------------------------------------------
# Turn an specifier into a string
sub specifier_name ($)
{
    my($specifier)=@_;
    return $specifier unless(ref $specifier);
    my $name='poe:';
    if($specifier->{kernel})
    {
        $name.='//';
        $name.=$specifier->{kernel};
    }
    if($specifier->{session})
    {
        $name.='/'.$specifier->{session};
        $name.='/' if $specifier->{state};
    }
    $name.=($specifier->{state}||'')    if $specifier->{state};
    return $name;
}
