BEGIN { $| = 1; print "1..5\n"; }
END {print "not ok 1\n" unless $loaded;}

$loaded = 1;
print "ok 1\n";

#######################################################
package My::Crawler1;

use strict;
    
use WWW::Crawler::LWP;
use vars qw(@ISA);
@ISA=qw(WWW::Crawler::LWP);

sub new
{
    my $package=shift @_;
    my $self=$package->SUPER::new(@_);
    $self->{UA}->agent("My::Crawler 0.1 (Mozilla;1;Linux)");
    return $self;
}

sub error
{
    my($self, $page, $response)=@_;
    warn "$page->{uri} wasn't fetched: ".$response->code."\n";
    print "not ok 2\n";
}

sub process 
{
    my($self, $page)=@_;
    print "ok 2\n";
}

sub include 
{
    my($self, $uri)=@_;
    return ($::LINK1 eq lc $uri);
}

#######################################################
package My::Crawler2;

use strict;
    
use vars qw(@ISA);
@ISA=qw(WWW::Crawler::LWP);

sub error
{
    my($self, $page, $response)=@_;
    print "ok 4\n";
}

sub process 
{
    my($self, $page)=@_;
    print "not ok 4\n";
}

sub include 
{
    my($self, $uri)=@_;
    return ($::LINK2 eq lc $uri);
}


#######################################################
package main;

use vars qw($LINK1 $LINK2);
$LINK1="http://www.yahoo.com/";
$LINK2="http://www.wibblebibbleziplieddoo/foo.bar.com";

my $crawler=My::Crawler1->new();
$crawler->schedule_link($LINK1);
$crawler->run();

print "ok 3\n";

$crawler=My::Crawler2->new();
$crawler->schedule_link($LINK2);
$crawler->run();

print "ok 5\n";

