BEGIN { $| = 1; print "1..2\n"; }
END {print "not ok 1\n" unless $loaded;}

$loaded = 1;
print "ok 1\n";

#######################################################
package My::Crawler;

use strict;
    
use WWW::Crawler::LWP;
use WWW::Crawler::RobotRules;
use vars qw(@ISA);

# We want enheritance to be as follows 
# WWW::Cralwer::RobotRules -> WWW::Cralwer::LWP -> WWW::Cralwer
# so that fetched() is called properly.  YUCK!
BEGIN {@WWW::Crawler::RobotRules::ISA=qw(WWW::Crawler::LWP);}

@ISA=qw(WWW::Crawler::RobotRules);
# print join "-", @ISA, '';
# print join "-", @WWW::Crawler::RobotRules::ISA, '';
# print join "-", @WWW::Crawler::LWP::ISA, '';

sub new
{
    my $package=shift @_;
    my $self=$package->SUPER::new(@_);
    return $self;
}

sub error
{
    my($self, $page, $response)=@_;
    return $self->error($page, $response) if $page->{robots_host};
    warn "$page->{uri} wasn't fetched: ".$response->code."\n";
}

sub process 
{
    my($self, $page)=@_;
    $::DENIED=0;
}

sub include 
{
    my($self, $uri)=@_;
    $::DENIED=1;
    return unless $::LINK eq lc $uri;
    return unless $self->SUPER::include($uri);
    $::DENIED=0;
    return 0;
}

#######################################################
package main;

use vars qw($LINK $DENIED);
$LINK="http://www.yahoo.com/gnn/index.html#hello";

$DENIED=0;
my $crawler=My::Crawler->new();
$crawler->schedule_link($LINK);
$crawler->run();

print $DENIED ? '' : 'not ';
print "ok 2\n";

