#include <stdio.h>

class ICompilerCallbacks {
public:
   virtual bool UserAborted() = 0;
   virtual void NotifyDoneParsing() = 0;
   virtual bool IsNTSC() = 0;
   virtual void NotifySubpictureCount(unsigned num_subpictures) = 0;
   virtual void AddSubpicture(unsigned base_field, const unsigned char* data) = 0;
   virtual int  ColorLookup(unsigned rgb) = 0;
   virtual void SetVTSNumber(int vts_number) = 0;
   virtual void SetAngle(int angle) = 0;
   virtual void Note(const char* msg) = 0;
   virtual void Warning(const char* msg) = 0;
   virtual void ErrorAtLine(const char* msg, int line) = 0;
   virtual void ErrorAtTime(const char* msg, unsigned field) = 0;
};

bool CompileSubtitles(FILE* subfile, ICompilerCallbacks* compiler_callbacks);
