/***********************************************************************
 Copyright 2002 Ben Rudiak-Gould.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA,
 or visit <http://www.gnu.org/copyleft/gpl.html>.
***********************************************************************/


#include "DVDSubber-dialog.h"
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <commctrl.h>
#include <windowsx.h>
#include <process.h>
#include "resource.h"

#include <stdio.h>


extern HINSTANCE g_hinstance;


void CloseDialog(CompileDialog* self, HWND hwnd) {
   delete self;
   EndDialog(hwnd, 1);
}


BOOL CALLBACK DlgProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam) {
   if (msg == WM_INITDIALOG) {
      SetWindowLong(hwnd, DWL_USER, (LONG)lparam);
      ((CompileDialog*)lparam)->hwnd = hwnd;
      SetEvent(((CompileDialog*)lparam)->event_created);
      return FALSE;
   } else {
      CompileDialog* self = (CompileDialog*)GetWindowLong(hwnd, DWL_USER);
      if (msg == WM_CLOSE) {
         CloseDialog(self, hwnd);
         return TRUE;
      } else if (msg == WM_APP) {
         if (self->button_pressed) {
            CloseDialog(self, hwnd);
         } else {
            self->autoclose = true;
         }
         return TRUE;
      } else if (msg == WM_COMMAND && (LOWORD(wparam)==IDC_OKCANCEL || LOWORD(wparam)==IDCANCEL)) {
         if (self->autoclose) {
            CloseDialog(self, hwnd);
         } else {
            self->button_pressed = true;
         }
         return TRUE;
      } else {
         return FALSE;
      }
   }
}


void ThreadProc(void* _self) {
   if (1 != DialogBoxParam(g_hinstance, MAKEINTRESOURCE(IDD_SUBCOMPILE), NULL, DlgProc, (LPARAM)_self)) {
      printf("DialogBoxParam failed: %d\n", GetLastError());
      SetEvent(((CompileDialog*)_self)->event_created);   // prevents deadlock in case DialogBoxParam fails
   }
}


CompileDialog::CompileDialog() {
   button_pressed = false;
   autoclose = false;
   hwnd = 0;
   HANDLE _event_created = CreateEvent(NULL, TRUE, FALSE, NULL);
   event_created = (void*)_event_created;
   _beginthread(ThreadProc, 0, this);
   WaitForSingleObject(_event_created, INFINITE);
   CloseHandle(_event_created);
}


void CompileDialog::AddMessage(const char* message) {
puts(">CompileDialog::AddMessage");
   HWND hlb = GetDlgItem((HWND)hwnd, IDC_MESSAGES);
   HDC hdc = GetDC(hlb);
   HFONT oldfont = (HFONT)SelectObject(hdc, GetWindowFont(hlb));
   SIZE size;
   if (GetTextExtentPoint32(hdc, message, lstrlen(message)+1, &size)) {
      ListBox_SetHorizontalExtent(hlb, size.cx);
   }
   SelectObject(hdc, oldfont);
   ReleaseDC(hlb, hdc);
   ListBox_AddString(hlb, message);
puts("<CompileDialog::AddMessage");
}


void CompileDialog::SetStage(const char* text) {
   SetWindowText(GetDlgItem((HWND)hwnd, IDC_STATUS), text);
}

#include <stdio.h>
void CompileDialog::SetProgress(unsigned numerator, unsigned denominator) {
   while (denominator >= 32768) {
      numerator >>= 1;
      denominator >>= 1;
   }
   HWND hprogress = GetDlgItem((HWND)hwnd, IDC_PROGRESS);
   SendMessage(hprogress, PBM_SETRANGE, 0, denominator<<16);
   SendMessage(hprogress, PBM_SETPOS, numerator, 0);
}


void CompileDialog::Destroy() {
   PostMessage((HWND)hwnd, WM_CLOSE, 0, 0);
}


void CompileDialog::SetButtonAutoclose(const char* text) {
   SetWindowText(GetDlgItem((HWND)hwnd, IDC_OKCANCEL), text);
   SendMessage((HWND)hwnd, WM_APP, 0, 0);
}
