struct DrawingBuf {
	unsigned char* ptr;
	int width, height;
	int xstride, ystride;
	int left, right, top, bottom;	// updated to reflect area drawn in
};

class Drawable {
public:
	virtual int GetAscent() const = 0;
	virtual int GetHeight() const = 0;
	virtual int GetWidth() const = 0;
	virtual int GetOnTime() const = 0;
	virtual int GetOffTime() const = 0;

	// the reason for the "times_2" is to avoid cascading roundoff errors when centering text
	virtual void DrawSelf(int time, DrawingBuf* buf, int left_times_2, int top) const = 0;

        // the lower two bits of each event time indicate the type of event:
        // 0 -> new subtitle on; 1 -> alpha change (fade), 2 -> subtitle off
        virtual unsigned* GetEventTimes(unsigned* buf, unsigned* bufend) const = 0;

        virtual bool NothingToDraw(int time) const = 0;

        virtual char* GetPrintableText(char* buf, char* bufend) const = 0;

	virtual int* GetSpaces(int left, int* buf, int* bufend) const = 0;
	virtual Drawable* BreakAt(int x) = 0;

        virtual ~Drawable() {}
};

struct FontInfo;


Drawable* new_Text(wchar_t* text, FontInfo* font, unsigned char textcolor, unsigned char halocolor, int spacing, int time0, int time1, int time2, int time3);
Drawable* new_TextLine(Drawable* l, Drawable* r);
Drawable* new_TextLines(Drawable* t, Drawable* b, int align);
Drawable* new_TextBox(Drawable* lines, int left, int top, int right, int bottom, int linealign, int boxalign, bool vertical);
Drawable* new_TextBoxen(Drawable* a, Drawable* b);
